/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.featurepack;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.APIVersion;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.featurepack.AbstractFeaturePackCommand;
import org.jboss.galleon.impl.ProvisioningUtil;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="get-info", description="Display information on a feature pack")
public class GetInfoCommand
extends AbstractFeaturePackCommand {
    public static final String PATCH_FOR = "Patch for ";
    @Option(completer=InfoTypeCompleter.class, description="Type of information to display (all, configs, dependencies, layers, options)")
    private String type;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't be called");
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.featurepack.core.CoreGetInfoCommand";
    }

    @Override
    protected String getCoreVersion(PmSession session) throws ProvisioningException {
        if (this.getFpl() == null && this.getFile() == null) {
            return APIVersion.getVersion();
        }
        if (this.getFpl() != null) {
            try {
                FeaturePackLocation loc = session.getGalleonContext(APIVersion.getVersion()).getResolvedLocation(null, this.getFpl());
                return session.getGalleonBuilder().getCoreVersion(loc);
            }
            catch (CommandExecutionException ex) {
                throw new ProvisioningException((Throwable)ex);
            }
        }
        String version = ProvisioningUtil.getFeaturePackDescription((Path)this.getFile().toPath()).getGalleonVersion();
        if (version == null || version.isEmpty()) {
            version = APIVersion.getVersion();
        }
        return version;
    }

    public String getType() {
        return this.type;
    }

    public static class InfoTypeCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return Arrays.asList("all", "configs", "Dependencies", "layers", "optional-packages", "options");
        }
    }
}

