/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.aesh.command.impl.converter.FileConverter;
import org.aesh.readline.AeshContext;
import org.aesh.readline.util.Parser;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class Util {
    static InputStream getResourceStream(String resource) throws CommandExecutionException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream pomIs = cl.getResourceAsStream(resource);
        if (pomIs == null) {
            throw new CommandExecutionException(resource + " not found");
        }
        return pomIs;
    }

    public static RepositorySystemSession newRepositorySession(RepositorySystem repoSystem, Path path, RepositoryListener listener, ProxySelector proxySelector, boolean offline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setRepositoryListener(listener);
        session.setOffline(offline);
        LocalRepository localRepo = new LocalRepository(path.toString());
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        if (proxySelector != null) {
            session.setProxySelector(proxySelector);
        }
        return session;
    }

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static String formatColumns(List<String> lst, int width, int height) {
        String[] array = new String[lst.size()];
        lst.toArray(array);
        return Parser.formatDisplayList((String[])array, (int)height, (int)width);
    }

    public static Path resolvePath(AeshContext ctx, String path) throws IOException {
        Path workDir = PmSession.getWorkDir(ctx);
        return Paths.get(new File(FileConverter.translatePath((String)workDir.toString(), (String)path)).getCanonicalPath(), new String[0]);
    }

    public static Path lookupInstallationDir(AeshContext ctx, Path install) throws ProvisioningException {
        if (install != null) {
            if (Files.exists(PathsUtils.getProvisioningXml((Path)install), new LinkOption[0])) {
                return install;
            }
            throw new ProvisioningException(BaseErrors.homeDirNotUsable((Path)install));
        }
        for (Path currentDir = PmSession.getWorkDir(ctx); currentDir != null; currentDir = currentDir.getParent()) {
            if (!Files.exists(PathsUtils.getProvisioningXml((Path)currentDir), new LinkOption[0])) continue;
            return currentDir;
        }
        throw new ProvisioningException(BaseErrors.homeDirNotUsable((Path)PmSession.getWorkDir(ctx)));
    }

    public static String formatChannel(FeaturePackLocation loc) {
        String channel = loc.getFrequency() == null ? loc.getChannel().getName() : loc.getChannel().getName() + "/" + loc.getFrequency();
        return (String)(loc.getUniverse() == null ? "" : loc.getUniverse() + "@") + (channel == null ? "" : channel);
    }
}

