/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.InstalledProducerCompleter;
import org.jboss.galleon.cli.cmd.installation.AbstractInstallationCommand;

@CommandDefinition(name="check-updates", description="Get available updates for a full installation or an identified feature pack")
public class CheckUpdatesCommand
extends AbstractInstallationCommand {
    public static final String UP_TO_DATE = "Up to date. No available updates nor patches.";
    public static final String UPDATES_AVAILABLE = "Some updates and/or patches are available.";
    public static final String FP_OPTION_NAME = "feature-packs";
    private static final String NONE = "none";
    public static final String ALL_DEPENDENCIES_OPTION_NAME = "include-all-dependencies";
    @Option(name="include-all-dependencies", hasValue=false, required=false, description="Include dependencies when checking for updates. Doesn't apply when specifying feature-packs", activator=AllDepsOptionActivator.class)
    boolean includeAll;
    @Option(name="feature-packs", hasValue=true, required=false, completer=InstalledProducerCompleter.class, description="The feature pack producers to check update for", activator=FPOptionActivator.class)
    String fp;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't be called");
    }

    public boolean isIncludeAll() {
        return this.includeAll;
    }

    public String getFp() {
        return this.fp;
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.maingrp.core.CoreCheckUpdatesCommand";
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    public static class AllDepsOptionActivator
    extends PmOptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            ParsedOption opt = pc.findLongOptionNoActivatorCheck(CheckUpdatesCommand.FP_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }

    public static class FPOptionActivator
    extends PmOptionActivator {
        public boolean isActivated(ParsedCommand pc) {
            ParsedOption opt = pc.findLongOptionNoActivatorCheck(CheckUpdatesCommand.ALL_DEPENDENCIES_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }
}

