/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.mvn.ArtifactException;
import org.jboss.galleon.cli.config.mvn.MavenCliSettings;
import org.jboss.galleon.cli.config.mvn.MavenMvnSettings;
import org.jboss.galleon.cli.config.mvn.MavenProxySelector;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;
import org.jboss.galleon.cli.config.mvn.MavenSettings;
import org.jboss.galleon.util.PropertyUtils;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

public class MavenConfig {
    static final String DEFAULT_SNAPSHOT_UPDATE_POLICY = "never";
    static final String DEFAULT_RELEASE_UPDATE_POLICY = "daily";
    static final boolean DEFAULT_ENABLE_SNAPSHOT = false;
    static final boolean DEFAULT_ENABLE_RELEASE = true;
    private static final List<String> VALID_UPDATE_POLICIES;
    public static final List<MavenRemoteRepository> DEFAULT_REPOSITORIES;
    public static final String JBOSS_REPO_URL = "https://repository.jboss.org/nexus/content/groups/public/";
    public static final String CENTRAL_REPO_URL = "https://repo1.maven.org/maven2/";
    public static final String GA_REPO_URL = "https://maven.repository.redhat.com/ga/";
    private static final MavenRemoteRepository JBOSS_REPO;
    private static final MavenRemoteRepository CENTRAL_REPO;
    private static final MavenRemoteRepository GA_REPO;
    private final Map<String, MavenRemoteRepository> repositories = new HashMap<String, MavenRemoteRepository>();
    private Path localRepository;
    private final List<MavenChangeListener> listeners = new ArrayList<MavenChangeListener>();
    private Path settings;
    private String defaultSnapshotPolicy = "never";
    private String defaultReleasePolicy = "daily";
    private boolean defaultEnableSnapshot = false;
    private boolean defaultEnableRelease = true;
    private boolean disableAdvertise;
    private boolean offline;

    void disableAdvertise() {
        this.disableAdvertise = true;
    }

    void enableAdvertise() {
        this.disableAdvertise = false;
    }

    public boolean isSnapshotEnabled() {
        return this.defaultEnableSnapshot;
    }

    public boolean isReleaseEnabled() {
        return this.defaultEnableRelease;
    }

    public void enableSnapshot(Boolean enable) throws XMLStreamException, IOException {
        this.defaultEnableSnapshot = enable;
        this.advertise();
    }

    public void resetSnapshot() throws XMLStreamException, IOException {
        this.defaultEnableSnapshot = false;
        this.advertise();
    }

    public void enableRelease(Boolean enable) throws XMLStreamException, IOException {
        this.defaultEnableRelease = enable;
        this.advertise();
    }

    public void resetRelease() throws XMLStreamException, IOException {
        this.defaultEnableRelease = true;
        this.advertise();
    }

    public String getDefaultSnapshotPolicy() {
        return this.defaultSnapshotPolicy;
    }

    public String getDefaultReleasePolicy() {
        return this.defaultReleasePolicy;
    }

    public void setDefaultSnapshotPolicy(String policy) throws ProvisioningException, XMLStreamException, IOException {
        MavenConfig.validatePolicy(policy);
        this.defaultSnapshotPolicy = policy;
        this.advertise();
    }

    public void resetDefaultSnapshotPolicy() throws ProvisioningException, XMLStreamException, IOException {
        this.defaultSnapshotPolicy = DEFAULT_SNAPSHOT_UPDATE_POLICY;
        this.advertise();
    }

    public void setDefaultReleasePolicy(String policy) throws ProvisioningException, XMLStreamException, IOException {
        MavenConfig.validatePolicy(policy);
        this.defaultReleasePolicy = policy;
        this.advertise();
    }

    public void resetDefaultReleasePolicy() throws ProvisioningException, XMLStreamException, IOException {
        this.defaultReleasePolicy = DEFAULT_RELEASE_UPDATE_POLICY;
        this.advertise();
    }

    public Path getSettings() {
        return this.settings;
    }

    public void addListener(MavenChangeListener listener) {
        this.listeners.add(listener);
    }

    static Path getDefaultMavenRepositoryPath() {
        String repoPath = PropertyUtils.getSystemProperty((String)"maven.repo.path");
        if (repoPath == null) {
            repoPath = PropertyUtils.getSystemProperty((String)"user.home") + File.separatorChar + ".m2" + File.separatorChar + "repository";
        }
        return Paths.get(repoPath, new String[0]);
    }

    public void addRemoteRepository(MavenRemoteRepository repo) throws XMLStreamException, IOException, ProvisioningException {
        this.repositories.put(repo.getName(), repo);
        this.advertise();
    }

    private void advertise() throws XMLStreamException, IOException {
        if (!this.disableAdvertise) {
            for (MavenChangeListener listener : this.listeners) {
                listener.configurationChanged(this);
            }
        }
    }

    public Collection<MavenRemoteRepository> getRemoteRepositories() {
        if (this.repositories.isEmpty()) {
            return DEFAULT_REPOSITORIES;
        }
        ArrayList<MavenRemoteRepository> repos = new ArrayList<MavenRemoteRepository>();
        repos.addAll(DEFAULT_REPOSITORIES);
        repos.addAll(this.repositories.values());
        return Collections.unmodifiableCollection(repos);
    }

    public Set<String> getRemoteRepositoryNames() {
        return Collections.unmodifiableSet(this.repositories.keySet());
    }

    public void removeRemoteRepository(String name) throws XMLStreamException, IOException, ProvisioningException {
        MavenRemoteRepository rep = this.repositories.remove(name);
        if (rep == null) {
            throw new ProvisioningException("Repository " + name + " doesn't exist");
        }
        this.advertise();
    }

    public void write(FormattingXmlStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("maven");
        if (this.localRepository != null) {
            writer.writeStartElement("local-repository");
            writer.writeCharacters(this.localRepository.toAbsolutePath().toString());
            writer.writeEndElement();
        }
        if (!this.defaultReleasePolicy.equals(DEFAULT_RELEASE_UPDATE_POLICY)) {
            writer.writeStartElement("releaseUpdatePolicy");
            writer.writeCharacters(this.defaultReleasePolicy);
            writer.writeEndElement();
        }
        if (!this.defaultSnapshotPolicy.equals(DEFAULT_SNAPSHOT_UPDATE_POLICY)) {
            writer.writeStartElement("snapshotUpdatePolicy");
            writer.writeCharacters(this.defaultSnapshotPolicy);
            writer.writeEndElement();
        }
        if (this.defaultEnableSnapshot) {
            writer.writeStartElement("enableSnapshot");
            writer.writeCharacters(Boolean.toString(this.defaultEnableSnapshot));
            writer.writeEndElement();
        }
        if (!this.defaultEnableRelease) {
            writer.writeStartElement("enableRelease");
            writer.writeCharacters(Boolean.toString(this.defaultEnableRelease));
            writer.writeEndElement();
        }
        if (this.settings != null) {
            writer.writeStartElement("settings");
            writer.writeCharacters(this.settings.toAbsolutePath().toString());
            writer.writeEndElement();
        }
        if (this.offline) {
            writer.writeStartElement("offline");
            writer.writeCharacters(Boolean.toString(this.offline));
            writer.writeEndElement();
        }
        if (this.repositories.isEmpty()) {
            writer.writeEmptyElement("repositories");
        } else {
            writer.writeStartElement("repositories");
            for (MavenRemoteRepository repo : this.repositories.values()) {
                writer.writeStartElement("repository");
                writer.writeAttribute("name", repo.getName());
                writer.writeAttribute("type", repo.getType());
                if (repo.getReleaseUpdatePolicy() != null) {
                    writer.writeAttribute("releaseUpdatePolicy", repo.getReleaseUpdatePolicy());
                }
                if (repo.getSnapshotUpdatePolicy() != null) {
                    writer.writeAttribute("snapshotUpdatePolicy", repo.getSnapshotUpdatePolicy());
                }
                if (repo.getEnableRelease() != null) {
                    writer.writeAttribute("enableRelease", Boolean.toString(repo.getEnableRelease()));
                }
                if (repo.getEnableSnapshot() != null) {
                    writer.writeAttribute("enableSnapshot", Boolean.toString(repo.getEnableSnapshot()));
                }
                writer.writeCharacters(repo.getUrl());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public Path getLocalRepository() {
        return this.localRepository == null ? MavenConfig.getDefaultMavenRepositoryPath() : this.localRepository;
    }

    public void setLocalRepository(Path path) throws XMLStreamException, IOException {
        this.localRepository = path.normalize();
        this.advertise();
    }

    public void resetLocalRepository() throws XMLStreamException, IOException {
        this.localRepository = null;
        this.advertise();
    }

    public void setSettings(Path path) throws XMLStreamException, IOException {
        this.settings = path.normalize();
        this.advertise();
    }

    public void resetSettings() throws XMLStreamException, IOException {
        this.settings = null;
        this.advertise();
    }

    public void enableOffline(Boolean offline) throws XMLStreamException, IOException {
        this.offline = offline;
        this.advertise();
    }

    public void resetOffline() throws XMLStreamException, IOException {
        this.offline = false;
        this.advertise();
    }

    public boolean isOffline() {
        return this.offline;
    }

    private boolean reuseMavenSettings() {
        return this.getSettings() != null;
    }

    public MavenSettings buildSettings(RepositorySystem repoSystem, RepositoryListener listener) throws ArtifactException {
        if (this.reuseMavenSettings()) {
            return new MavenMvnSettings(this, repoSystem, listener);
        }
        return new MavenCliSettings(this, repoSystem, listener);
    }

    static void validatePolicy(String policy) throws ProvisioningException {
        if (policy == null) {
            return;
        }
        String radical = "interval:";
        if (policy.startsWith(radical)) {
            String minutes = policy.substring(radical.length());
            try {
                Integer.parseInt(minutes);
            }
            catch (NumberFormatException ex) {
                throw new ProvisioningException(CliErrors.invalidMavenUpdatePolicy(policy));
            }
            return;
        }
        if (!VALID_UPDATE_POLICIES.contains(policy)) {
            throw new ProvisioningException(CliErrors.invalidMavenUpdatePolicy(policy));
        }
    }

    public static List<String> getUpdatePolicies() {
        return VALID_UPDATE_POLICIES;
    }

    public List<RemoteRepository> getMissingDefaultRepositories(Set<String> configuredRepos, MavenProxySelector selector, Proxy proxy) throws ArtifactException {
        ArrayList<RemoteRepository> lst = new ArrayList<RemoteRepository>();
        if (!configuredRepos.contains(CENTRAL_REPO_URL)) {
            lst.add(this.buildRemoteRepository(CENTRAL_REPO, selector, proxy));
        }
        if (!configuredRepos.contains(JBOSS_REPO_URL)) {
            lst.add(this.buildRemoteRepository(JBOSS_REPO, selector, proxy));
        }
        if (!configuredRepos.contains(GA_REPO_URL)) {
            lst.add(this.buildRemoteRepository(GA_REPO, selector, proxy));
        }
        return lst;
    }

    public RemoteRepository buildRemoteRepository(MavenRemoteRepository repo, MavenProxySelector selector, Proxy proxy) throws ArtifactException {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getName(), repo.getType(), repo.getUrl());
        builder.setSnapshotPolicy(new RepositoryPolicy(repo.getEnableSnapshot() == null ? this.isSnapshotEnabled() : repo.getEnableSnapshot().booleanValue(), repo.getSnapshotUpdatePolicy() == null ? this.getDefaultSnapshotPolicy() : repo.getSnapshotUpdatePolicy(), "warn"));
        builder.setReleasePolicy(new RepositoryPolicy(repo.getEnableRelease() == null ? this.isReleaseEnabled() : repo.getEnableRelease().booleanValue(), repo.getReleaseUpdatePolicy() == null ? this.getDefaultReleasePolicy() : repo.getReleaseUpdatePolicy(), "warn"));
        try {
            if (selector != null && selector.proxyFor(new URL(repo.getUrl()).getHost())) {
                builder.setProxy(proxy);
            }
        }
        catch (MalformedURLException ex) {
            throw new ArtifactException(ex.getMessage(), ex);
        }
        return builder.build();
    }

    static {
        ArrayList<String> policies = new ArrayList<String>();
        policies.add(DEFAULT_SNAPSHOT_UPDATE_POLICY);
        policies.add("always");
        policies.add(DEFAULT_RELEASE_UPDATE_POLICY);
        policies.add("interval:");
        VALID_UPDATE_POLICIES = Collections.unmodifiableList(policies);
        DEFAULT_REPOSITORIES = new ArrayList<MavenRemoteRepository>();
        JBOSS_REPO = new MavenRemoteRepository("jboss-public-repository-group", "default", JBOSS_REPO_URL);
        CENTRAL_REPO = new MavenRemoteRepository("maven-central", "default", CENTRAL_REPO_URL);
        GA_REPO = new MavenRemoteRepository("jboss-ga", "default", GA_REPO_URL);
        DEFAULT_REPOSITORIES.add(CENTRAL_REPO);
        DEFAULT_REPOSITORIES.add(JBOSS_REPO);
        DEFAULT_REPOSITORIES.add(GA_REPO);
    }

    public static interface MavenChangeListener {
        public void configurationChanged(MavenConfig var1) throws XMLStreamException, IOException;
    }
}

