/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.installation;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GalleonCommandExecutionContext;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.cli.cmd.installation.AbstractInstallationCommand;
import org.jboss.galleon.util.PathsUtils;

@CommandDefinition(name="remove-universe", description="Remove a universe. Without any name provided, remove the default universe")
public class RemoveUniverseCommand
extends AbstractInstallationCommand {
    @Option(completer=UniverseCompleter.class, required=false, description="Universe name")
    private String name;

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.installation.core.CoreRemoveUniverseCommand";
    }

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CommandDomain getDomain() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static class UniverseCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)completerInvocation.getCommand();
            Path installation = cmd.getInstallationDirectory(completerInvocation.getAeshContext());
            try {
                Path p = PathsUtils.getProvisioningXml((Path)installation);
                String coreVersion = completerInvocation.getPmSession().getGalleonBuilder().getCoreVersion(p);
                GalleonCommandExecutionContext bridge = completerInvocation.getPmSession().getGalleonContext(coreVersion);
                names.addAll(bridge.getUniverseNames(installation));
            }
            catch (ProvisioningException | CommandExecutionException ex) {
                CliLogging.completionException(ex);
                return Collections.emptyList();
            }
            return names;
        }
    }
}

