/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ResolvedFeatureId {
    final ResolvedSpecId specId;
    final Map<String, Object> params;
    final Boolean child;

    public static Builder builder(ResolvedSpecId specId) {
        return new Builder(specId);
    }

    public static Builder builder(ArtifactCoords.Gav gav, String spec) {
        return new Builder(gav, spec);
    }

    public static ResolvedFeatureId fromString(String str) throws ProvisioningDescriptionException {
        int equals;
        int endIndex;
        int length = str.length();
        if (length == 0) {
            ResolvedFeatureId.formatException(str);
        }
        int nextIndex = 0;
        char c = str.charAt(nextIndex++);
        StringBuilder buf = new StringBuilder(length);
        ResolvedSpecId specId = null;
        String groupId = null;
        String artifactId = null;
        String version = null;
        while (nextIndex < length) {
            if (c == '#') {
                if (artifactId == null || version != null || buf.length() == 0) {
                    ResolvedFeatureId.formatException(str);
                }
                version = buf.toString();
                buf.setLength(0);
            } else if (c == ':') {
                if (buf.length() == 0) {
                    ResolvedFeatureId.formatException(str);
                }
                if (groupId == null) {
                    groupId = buf.toString();
                } else if (artifactId == null) {
                    artifactId = buf.toString();
                } else if (version == null) {
                    ResolvedFeatureId.formatException(str);
                } else {
                    specId = new ResolvedSpecId(ArtifactCoords.newGav(groupId, artifactId, version), buf.toString());
                    break;
                }
                buf.setLength(0);
            } else {
                buf.append(c);
            }
            c = str.charAt(nextIndex++);
        }
        if (specId == null) {
            ResolvedFeatureId.formatException(str);
        }
        if ((endIndex = str.indexOf(44, nextIndex + 3)) < 0) {
            int equals2 = str.indexOf(61, nextIndex + 1);
            if (equals2 < 0 || equals2 == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            return new ResolvedFeatureId(specId, Collections.singletonMap(str.substring(nextIndex, equals2), str.substring(equals2 + 1)));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        int lastComma = nextIndex - 1;
        while (endIndex > 0) {
            equals = str.indexOf(61, lastComma + 2);
            if (equals < 0 || equals == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1, endIndex));
            lastComma = endIndex;
            endIndex = str.indexOf(44, endIndex + 1);
        }
        equals = str.indexOf(61, lastComma + 2);
        if (equals < 0 || equals == str.length() - 1) {
            ResolvedFeatureId.formatException(str);
        }
        params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1));
        return new ResolvedFeatureId(specId, params);
    }

    private static void formatException(String str) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException("'" + str + "' does not follow format group_id:artifact_id:version#spec_name:param_name=value(,param_name=value)*");
    }

    public static ResolvedFeatureId create(ArtifactCoords.Gav gav, String spec, String param, String value) {
        return new ResolvedFeatureId(new ResolvedSpecId(gav, spec), Collections.singletonMap(param, value));
    }

    public static ResolvedFeatureId create(ResolvedSpecId specId, String param, String value) {
        return new ResolvedFeatureId(specId, Collections.singletonMap(param, value));
    }

    ResolvedFeatureId(ResolvedSpecId specId, Map<String, Object> params) {
        this(specId, params, null);
    }

    ResolvedFeatureId(ResolvedSpecId specId, Map<String, Object> params, Boolean child) {
        this.specId = specId;
        Map<Object, Object> filtered = Collections.emptyMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if ("PM_UNDEFINED".equals(entry.getValue())) continue;
            filtered = CollectionUtils.put(filtered, entry.getKey(), entry.getValue());
        }
        if (filtered.isEmpty()) {
            filtered = params;
        }
        this.params = CollectionUtils.unmodifiable(filtered);
        this.child = child;
    }

    public ResolvedSpecId getSpecId() {
        return this.specId;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    boolean isChildRef() {
        return this.child != null && this.child != false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.specId == null ? 0 : this.specId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvedFeatureId other = (ResolvedFeatureId)obj;
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.specId == null ? other.specId != null : !this.specId.equals(other.specId));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.specId);
        if (!this.params.isEmpty()) {
            buf.append(':');
            StringUtils.append(buf, this.params.entrySet());
        }
        return buf.toString();
    }

    public static class Builder {
        private final ResolvedSpecId specId;
        private Map<String, Object> params = Collections.emptyMap();

        private Builder(ArtifactCoords.Gav gav, String spec) {
            this.specId = new ResolvedSpecId(gav, spec);
        }

        private Builder(ResolvedSpecId specId) {
            this.specId = specId;
        }

        public Builder setParam(String name, Object value) {
            this.params = CollectionUtils.put(this.params, name, value);
            return this;
        }

        public ResolvedFeatureId build() throws ProvisioningDescriptionException {
            if (this.params.isEmpty()) {
                throw new ProvisioningDescriptionException("Failed to create an instance of ResolvedFeatureId for " + this.specId + ": params have not been initialized");
            }
            return new ResolvedFeatureId(this.specId, this.params);
        }
    }
}

