/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.util.CollectionUtils;

public class FeatureAnnotation {
    public static final String FEATURE_BRANCH = "feature-branch";
    public static final String FEATURE_BRANCH_PARENT_CHILDREN = "parent-children";
    public static final String FEATURE_BRANCH_SPEC = "spec";
    public static final String FEATURE_BRANCH_BATCH = "batch";
    final String name;
    private Map<String, String> elems = Collections.emptyMap();

    public static FeatureAnnotation parentChildrenBranch() {
        return new FeatureAnnotation(FEATURE_BRANCH).setElement(FEATURE_BRANCH_PARENT_CHILDREN);
    }

    public static FeatureAnnotation parentChildrenBranch(boolean batch) {
        return FeatureAnnotation.parentChildrenBranch().setElement(FEATURE_BRANCH_BATCH, String.valueOf(batch));
    }

    public static FeatureAnnotation specBranch(boolean spec) {
        return new FeatureAnnotation(FEATURE_BRANCH).setElement(FEATURE_BRANCH_SPEC, String.valueOf(spec));
    }

    public static FeatureAnnotation specBranch(boolean spec, boolean batch) {
        return FeatureAnnotation.specBranch(spec).setElement(FEATURE_BRANCH_BATCH, String.valueOf(batch));
    }

    public FeatureAnnotation(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public FeatureAnnotation setElement(String name) {
        return this.setElement(name, null);
    }

    public FeatureAnnotation setElement(String name, String value) {
        this.elems = CollectionUtils.put(this.elems, name, value);
        return this;
    }

    public boolean hasElements() {
        return !this.elems.isEmpty();
    }

    public Map<String, String> getElements() {
        return this.elems;
    }

    public boolean hasElement(String name) {
        return this.elems.containsKey(name);
    }

    public String getElement(String name) {
        return this.elems.get(name);
    }

    public String getElement(String name, String defaultValue) {
        return this.elems.getOrDefault(name, defaultValue);
    }

    public String getElement(String elem, boolean required) throws ProvisioningDescriptionException {
        String value = this.elems.get(elem);
        if (value == null) {
            if (required) {
                throw new ProvisioningDescriptionException("Annotation " + this.name + " is missing required element " + elem);
            }
            return null;
        }
        return value;
    }

    public List<String> getElementAsList(String name) {
        return this.parseList(this.elems.get(name));
    }

    public List<String> getElementAsList(String name, String defaultValue) {
        return this.parseList(this.elems.getOrDefault(name, defaultValue));
    }

    private List<String> parseList(String str) {
        if (str == null || str.isEmpty()) {
            return Collections.emptyList();
        }
        int comma = str.indexOf(44);
        if (comma < 1) {
            return Collections.singletonList(str.trim());
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String paramName = tokenizer.nextToken().trim();
            if (paramName.isEmpty()) continue;
            list.add(paramName);
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elems == null ? 0 : this.elems.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureAnnotation other = (FeatureAnnotation)obj;
        if (this.elems == null ? other.elems != null : !this.elems.equals(other.elems)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("name=").append(this.name);
        if (!this.elems.isEmpty()) {
            buf.append(" elems={");
            Iterator<Map.Entry<String, String>> i = this.elems.entrySet().iterator();
            Map.Entry<String, String> entry = i.next();
            buf.append(entry.getKey());
            if (entry.getValue() != null) {
                buf.append('=').append(entry.getValue());
            }
            while (i.hasNext()) {
                entry = i.next();
                buf.append(';').append(entry.getKey());
                if (entry.getValue() == null) continue;
                buf.append('=').append(entry.getValue());
            }
            buf.append('}');
        }
        return buf.toString();
    }
}

