/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class ConfigXml {
    private static final ConfigXml INSTANCE = new ConfigXml();
    public static final String NAMESPACE_1_0 = "urn:wildfly:pm-config:1.0";

    public static ConfigXml getInstance() {
        return INSTANCE;
    }

    public static void readConfig(XMLExtendedStreamReader reader, ConfigModel.Builder configBuilder) throws XMLStreamException {
        String name = null;
        Boolean inheritFeatures = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    configBuilder.setName(name);
                    continue block5;
                }
                case MODEL: {
                    configBuilder.setModel(reader.getAttributeValue(i));
                    continue block5;
                }
                case INHERIT_FEATURES: {
                    inheritFeatures = Boolean.parseBoolean(reader.getAttributeValue(i));
                    configBuilder.setInheritFeatures(inheritFeatures);
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null && inheritFeatures != null) {
            throw new XMLStreamException(Attribute.INHERIT_FEATURES + " attribute can't be used w/o attribute " + Attribute.NAME);
        }
        FeatureGroupXml.readFeatureGroupConfigBody(reader, configBuilder);
    }

    protected static enum Attribute implements XmlNameProvider
    {
        INHERIT_FEATURES("inherit-features"),
        NAME("name"),
        MODEL("model"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(4);
            attributes.put(new QName(INHERIT_FEATURES.getLocalName()), INHERIT_FEATURES);
            attributes.put(new QName(NAME.getLocalName()), NAME);
            attributes.put(new QName(MODEL.getLocalName()), MODEL);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:wildfly:pm-config:1.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ConfigXml.NAMESPACE_1_0;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(2);
            elementsByLocal.put(Element.CONFIG.name, CONFIG);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

