/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class ConfigXmlWriter
extends BaseXmlWriter<ConfigModel> {
    private static final ConfigXmlWriter INSTANCE = new ConfigXmlWriter();

    public static ConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ConfigXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ConfigModel config) {
        return this.toElement(config, "urn:wildfly:pm-config:1.0");
    }

    protected ElementNode toElement(ConfigModel config, String ns) {
        ElementNode configE = ConfigXmlWriter.addElement(null, ConfigXml.Element.CONFIG.getLocalName(), ns);
        if (config.getModel() != null) {
            ConfigXmlWriter.addAttribute(configE, ConfigXml.Attribute.MODEL, config.getModel());
        }
        if (config.hasConfigDeps()) {
            ElementNode configDeps = ConfigXmlWriter.addElement(configE, FeatureGroupXml.Element.CONFIG_DEPS.getLocalName(), ns);
            for (Map.Entry<String, ConfigId> dep : config.getConfigDeps().entrySet()) {
                ElementNode configDep = ConfigXmlWriter.addElement(configDeps, FeatureGroupXml.Element.CONFIG_DEP.getLocalName(), ns);
                ConfigXmlWriter.addAttribute(configDep, FeatureGroupXml.Attribute.ID.getLocalName(), dep.getKey());
                ConfigId configId = dep.getValue();
                if (configId.getModel() != null) {
                    ConfigXmlWriter.addAttribute(configDep, FeatureGroupXml.Attribute.MODEL.getLocalName(), configId.getModel());
                }
                if (configId.getName() == null) continue;
                ConfigXmlWriter.addAttribute(configDep, FeatureGroupXml.Attribute.NAME.getLocalName(), configId.getName());
            }
        }
        FeatureGroupXmlWriter.addFeatureGroupDepBody(config, configE, ns);
        return configE;
    }
}

