/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class FeatureGroupXmlWriter
extends BaseXmlWriter<FeatureGroup> {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final FeatureGroupXmlWriter INSTANCE = new FeatureGroupXmlWriter();

    public static FeatureGroupXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeatureGroupXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeatureGroup config) {
        return this.toElement(config, "urn:wildfly:pm-feature-group:1.0");
    }

    protected ElementNode toElement(FeatureGroup featureGroup, String ns) {
        ElementNode fgE = FeatureGroupXmlWriter.addElement(null, FeatureGroupXml.Element.FEATURE_GROUP_SPEC.getLocalName(), ns);
        if (featureGroup.getName() != null) {
            FeatureGroupXmlWriter.addAttribute(fgE, FeatureGroupXml.Attribute.NAME, featureGroup.getName());
        }
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(fgE, featureGroup, ns);
        if (featureGroup.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(featureGroup, FeatureGroupXmlWriter.addElement(fgE, FeatureGroupXml.Element.PACKAGES.getLocalName(), ns));
        }
        return fgE;
    }

    static void writeFeatureGroupSpecBody(ElementNode configE, ConfigItemContainer featureGroup, String ns) {
        if (!featureGroup.hasItems()) {
            return;
        }
        String currentOrigin = null;
        ElementNode parent = configE;
        for (ConfigItem item : featureGroup.getItems()) {
            String itemOrigin = item.getOrigin();
            if (itemOrigin != null) {
                if (!itemOrigin.equals(currentOrigin)) {
                    parent = FeatureGroupXmlWriter.addElement(configE, FeatureGroupXml.Element.ORIGIN.getLocalName(), ns);
                    FeatureGroupXmlWriter.addAttribute(parent, FeatureGroupXml.Attribute.NAME, itemOrigin);
                    currentOrigin = itemOrigin;
                }
            } else if (currentOrigin != null) {
                currentOrigin = null;
                parent = configE;
            }
            if (item.isGroup()) {
                FeatureGroupXmlWriter.writeFeatureGroupDependency(parent, (FeatureGroup)item, ns);
                continue;
            }
            FeatureGroupXmlWriter.addFeatureConfig(parent, (FeatureConfig)item, ns);
        }
    }

    private static void writeFeatureGroupDependency(ElementNode depsE, FeatureGroup dep, String ns) {
        ElementNode depE = FeatureGroupXmlWriter.addElement(depsE, FeatureGroupXml.Element.FEATURE_GROUP.getLocalName(), ns);
        FeatureGroupXmlWriter.addFeatureGroupDepBody(dep, depE, ns);
    }

    public static void addFeatureGroupDepBody(FeatureGroupSupport dep, ElementNode depE, String ns) {
        if (dep.getName() != null) {
            FeatureGroupXmlWriter.addAttribute(depE, FeatureGroupXml.Attribute.NAME, dep.getName());
        }
        if (!dep.isInheritFeatures()) {
            FeatureGroupXmlWriter.addAttribute(depE, FeatureGroupXml.Attribute.INHERIT_FEATURES, FALSE);
        }
        if (dep.hasProperties()) {
            ElementNode propsE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.PROPS.getLocalName(), ns);
            for (Map.Entry<String, String> prop : dep.getProperties().entrySet()) {
                ElementNode propE = FeatureGroupXmlWriter.addElement(propsE, FeatureGroupXml.Element.PROP.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(propE, FeatureGroupXml.Attribute.NAME, prop.getKey());
                FeatureGroupXmlWriter.addAttribute(propE, FeatureGroupXml.Attribute.VALUE, prop.getValue());
            }
        }
        FeatureGroupXmlWriter.addFeatureGroupIncludeExclude(dep, ns, depE);
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(depE, dep, ns);
        if (dep.hasExternalFeatureGroups()) {
            for (Map.Entry<String, FeatureGroup> entry : dep.getExternalFeatureGroups().entrySet()) {
                ElementNode fpE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.ORIGIN.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(fpE, FeatureGroupXml.Attribute.NAME, entry.getKey());
                FeatureGroupXmlWriter.addFeatureGroupIncludeExclude(entry.getValue(), ns, fpE);
            }
        }
        if (dep.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(dep, FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.PACKAGES.getLocalName(), ns));
        }
    }

    static void addFeatureGroupIncludeExclude(FeatureGroupSupport dep, String ns, ElementNode depE) {
        ElementNode includeE;
        ElementNode excludeE;
        if (dep.hasExcludedSpecs()) {
            for (SpecId specId : dep.getExcludedSpecs()) {
                excludeE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.EXCLUDE.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(excludeE, FeatureGroupXml.Attribute.SPEC, specId.toString());
            }
        }
        if (dep.hasExcludedFeatures()) {
            for (Map.Entry entry : dep.getExcludedFeatures().entrySet()) {
                excludeE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.EXCLUDE.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(excludeE, FeatureGroupXml.Attribute.FEATURE_ID, ((FeatureId)entry.getKey()).toString());
                if (entry.getValue() == null) continue;
                FeatureGroupXmlWriter.addAttribute(excludeE, FeatureGroupXml.Attribute.PARENT_REF, (String)entry.getValue());
            }
        }
        if (dep.hasIncludedSpecs()) {
            for (SpecId specId : dep.getIncludedSpecs()) {
                includeE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.INCLUDE.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(includeE, FeatureGroupXml.Attribute.SPEC, specId.toString());
            }
        }
        if (dep.hasIncludedFeatures()) {
            for (Map.Entry entry : dep.getIncludedFeatures().entrySet()) {
                includeE = FeatureGroupXmlWriter.addElement(depE, FeatureGroupXml.Element.INCLUDE.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(includeE, FeatureGroupXml.Attribute.FEATURE_ID, ((FeatureId)entry.getKey()).toString());
                FeatureConfig fc = (FeatureConfig)entry.getValue();
                if (fc.getParentRef() != null) {
                    FeatureGroupXmlWriter.addAttribute(includeE, FeatureGroupXml.Attribute.PARENT_REF, fc.getParentRef());
                }
                if (fc == null) continue;
                FeatureGroupXmlWriter.addFeatureConfigBody(includeE, fc, ns);
            }
        }
    }

    private static void addFeatureConfigBody(ElementNode fcE, FeatureConfig fc, String ns) {
        ElementNode paramE;
        if (fc.hasFeatureDeps()) {
            for (FeatureDependencySpec featureDependencySpec : fc.getFeatureDeps()) {
                ElementNode depE = FeatureGroupXmlWriter.addElement(fcE, FeatureGroupXml.Element.DEPENDS.getLocalName(), ns);
                if (featureDependencySpec.getOrigin() != null) {
                    FeatureGroupXmlWriter.addAttribute(depE, FeatureGroupXml.Attribute.ORIGIN, featureDependencySpec.getOrigin());
                }
                FeatureGroupXmlWriter.addAttribute(depE, FeatureGroupXml.Attribute.FEATURE_ID, featureDependencySpec.getFeatureId().toString());
                if (!featureDependencySpec.isInclude()) continue;
                FeatureGroupXmlWriter.addAttribute(depE, FeatureGroupXml.Attribute.INCLUDE, TRUE);
            }
        }
        if (fc.hasParams()) {
            for (Map.Entry entry : fc.getParams().entrySet()) {
                paramE = FeatureGroupXmlWriter.addElement(fcE, FeatureGroupXml.Element.PARAM.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(paramE, FeatureGroupXml.Attribute.NAME, (String)entry.getKey());
                FeatureGroupXmlWriter.addAttribute(paramE, FeatureGroupXml.Attribute.VALUE, (String)entry.getValue());
            }
        }
        if (fc.hasResetParams()) {
            for (String string : fc.getResetParams()) {
                paramE = FeatureGroupXmlWriter.addElement(fcE, FeatureGroupXml.Element.RESET_PARAM.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(paramE, FeatureGroupXml.Attribute.PARAM, string);
            }
        }
        if (fc.hasUnsetParams()) {
            for (String string : fc.getUnsetParams()) {
                paramE = FeatureGroupXmlWriter.addElement(fcE, FeatureGroupXml.Element.UNSET_PARAM.getLocalName(), ns);
                FeatureGroupXmlWriter.addAttribute(paramE, FeatureGroupXml.Attribute.PARAM, string);
            }
        }
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(fcE, fc, ns);
    }

    public static void addFeatureConfig(ElementNode parentE, FeatureConfig fc, String ns) {
        ElementNode fcE = FeatureGroupXmlWriter.addElement(parentE, FeatureGroupXml.Element.FEATURE.getLocalName(), ns);
        FeatureGroupXmlWriter.addAttribute(fcE, FeatureGroupXml.Attribute.SPEC, fc.getSpecId().toString());
        if (fc.getParentRef() != null) {
            FeatureGroupXmlWriter.addAttribute(fcE, FeatureGroupXml.Attribute.PARENT_REF, fc.getParentRef());
        }
        FeatureGroupXmlWriter.addFeatureConfigBody(fcE, fc, ns);
    }
}

