/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class PackageXmlParser10
implements PlugableXmlParser<PackageSpec.Builder> {
    public static final String NAMESPACE_1_0 = "urn:wildfly:pm-package:1.0";
    public static final QName ROOT_1_0 = new QName("urn:wildfly:pm-package:1.0", Element.PACKAGE_SPEC.getLocalName());

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, PackageSpec.Builder pkgBuilder) throws XMLStreamException {
        pkgBuilder.setName(this.parseName(reader, false));
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            PackageDepsSpecXmlParser.parsePackageDeps(Element.DEPENDENCIES, reader, pkgBuilder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLExtendedStreamReader reader, boolean exclusive) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        boolean parsedTarget = false;
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    path = reader.getAttributeValue(i);
                    parsedTarget = true;
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!parsedTarget) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (exclusive) {
            ParsingUtils.parseNoContent(reader);
        }
        return path;
    }

    static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(2);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        DEPENDENCIES("dependencies"),
        PACKAGE_SPEC("package-spec"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:wildfly:pm-package:1.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(PackageXmlParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return PackageXmlParser10.NAMESPACE_1_0;
        }

        static {
            elements = new HashMap<QName, Element>(3);
            elements.put(new QName(PackageXmlParser10.NAMESPACE_1_0, Element.DEPENDENCIES.name), DEPENDENCIES);
            elements.put(new QName(PackageXmlParser10.NAMESPACE_1_0, Element.PACKAGE_SPEC.name), PACKAGE_SPEC);
            elements.put(null, UNKNOWN);
        }
    }
}

