/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.util.logging.LogManager;
import org.aesh.command.Command;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.readline.ReadlineConsole;
import org.jboss.galleon.cli.ChangesCommand;
import org.jboss.galleon.cli.Configuration;
import org.jboss.galleon.cli.PmExitCommand;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.UninstallCommand;
import org.jboss.galleon.cli.UniverseCommand;
import org.jboss.galleon.cli.UpgradeCommand;
import org.jboss.galleon.cli.cmd.filesystem.CdCommand;
import org.jboss.galleon.cli.cmd.filesystem.LsCommand;
import org.jboss.galleon.cli.cmd.filesystem.PmMkdir;
import org.jboss.galleon.cli.cmd.filesystem.PmRm;
import org.jboss.galleon.cli.cmd.filesystem.PwdCommand;
import org.jboss.galleon.cli.cmd.plugin.InstallCommand;
import org.jboss.galleon.cli.cmd.state.SearchCommand;
import org.jboss.galleon.cli.cmd.state.StateCommand;
import org.jboss.galleon.cli.cmd.state.UndoCommand;
import org.jboss.galleon.cli.cmd.state.feature.FeatureCommand;

public class CliMain {
    public static void main(String[] args) throws Exception {
        Configuration config = Configuration.parse();
        PmSession pmSession = new PmSession(config);
        InstallCommand install = new InstallCommand(pmSession);
        FeatureCommand feature = new FeatureCommand(pmSession);
        StateCommand state = new StateCommand(pmSession);
        AeshCommandRegistryBuilder builder = new AeshCommandRegistryBuilder().command(feature).command(state).command(install.createCommand()).command(ChangesCommand.class).command(UpgradeCommand.class).command(UninstallCommand.class).command(CdCommand.class).command(PmExitCommand.class).command(LsCommand.class).command(PmMkdir.class).command(PmRm.class).command(PwdCommand.class).command(SearchCommand.class).command(UndoCommand.class).command(UniverseCommand.class);
        StateCommand.addActionCommands(builder);
        CommandRegistry registry = builder.create();
        Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings = SettingsBuilder.builder().logging(CliMain.overrideLogging()).commandRegistry(registry).enableOperatorParser(true).persistHistory(true).commandActivatorProvider(pmSession).historyFile(config.getHistoryFile()).echoCtrl(false).enableExport(false).enableAlias(false).completerInvocationProvider(pmSession).optionActivatorProvider(pmSession).commandInvocationProvider(pmSession).build();
        install.setAeshContext(settings.aeshContext());
        state.setAeshContext(settings.aeshContext());
        pmSession.setOut(settings.stdOut());
        pmSession.setErr(settings.stdErr());
        ReadlineConsole console = new ReadlineConsole(settings);
        console.setPrompt(PmSession.buildPrompt(settings.aeshContext()));
        console.start();
    }

    private static boolean overrideLogging() {
        return LogManager.getLogManager().getClass() == LogManager.class && System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null;
    }
}

