/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.cli.UniverseLocation;

public class Configuration {
    private static final File DEFAULT_HISTORY_FILE = new File(System.getProperty("user.home"), ".galleon-history");
    private final List<UniverseLocation> universes = new ArrayList<UniverseLocation>();
    private String mavenRepositoryURL;
    private File historyFile = DEFAULT_HISTORY_FILE;

    private Configuration() {
    }

    public File getHistoryFile() {
        return this.historyFile;
    }

    public List<UniverseLocation> getUniversesLocations() {
        return Collections.unmodifiableList(this.universes);
    }

    public String getMavenRepositoryURL() {
        return this.mavenRepositoryURL;
    }

    public static Configuration parse() {
        Configuration config = new Configuration();
        config.universes.add(UniverseLocation.DEFAULT);
        return config;
    }
}

