/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.Universe;
import org.jboss.galleon.cli.UniverseLocation;

public class Universes {
    private final List<Universe> universes = new ArrayList<Universe>();
    private ArtifactRepositoryManager manager;

    private Universes(ArtifactRepositoryManager manager) {
        this.manager = manager;
    }

    public List<Universe> getUniverses() {
        return Collections.unmodifiableList(this.universes);
    }

    public ArtifactCoords resolveStream(String name) throws ArtifactException {
        for (Universe universe : this.universes) {
            ArtifactCoords coords = universe.resolveStream(name);
            if (coords == null) continue;
            return coords;
        }
        return null;
    }

    private void addUniverse(Universe universe) {
        this.universes.add(universe);
    }

    static Universes buildUniverses(ArtifactRepositoryManager manager, List<UniverseLocation> locations) throws Exception {
        Universes universes = new Universes(manager);
        try {
            for (UniverseLocation loc : locations) {
                universes.addUniverse(Universe.buildUniverse(manager, loc));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return universes;
    }
}

