/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.aesh.command.CommandException;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.GavCompleter;
import org.jboss.galleon.cli.MavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ProvisioningFeaturePackCommand;
import org.jboss.galleon.cli.StreamCompleter;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.ProvisioningRuntime;

public abstract class AbstractPluginsCommand
extends AbstractDynamicCommand {
    private static final String VERBOSE_NAME = "verbose";
    private static final String FP_NAME = "fp";
    private AeshContext ctx;

    public AbstractPluginsCommand(PmSession pmSession) {
        super(pmSession);
    }

    public void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    protected boolean isVerbose() {
        return this.contains(VERBOSE_NAME);
    }

    @Override
    protected void doValidateOptions() throws CommandException {
        String id = this.getId(this.pmSession);
        if (id == null) {
            throw new CommandException("feature-pack has not been set.");
        }
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("org.jboss.pm.tool.arg").hasValue(true).description("stream name").type(String.class).optionType(OptionType.ARGUMENT).completer(StreamCompleter.class).activator(ProvisioningFeaturePackCommand.StreamNameActivator.class).build());
        options.add(ProcessedOptionBuilder.builder().name(FP_NAME).hasValue(true).description("Feature-pack maven gav").type(String.class).optionType(OptionType.NORMAL).completer(GavCompleter.class).activator(ProvisioningFeaturePackCommand.FPActivator.class).build());
        options.add(ProcessedOptionBuilder.builder().name(VERBOSE_NAME).hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        return Collections.emptyList();
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        ProvisioningManager manager = this.getManager(this.ctx);
        FeaturePackConfig config = FeaturePackConfig.forGav(ArtifactCoords.newGav(id));
        ProvisioningConfig provisioning = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(config)).build();
        ProvisioningRuntime runtime = manager.getRuntime(provisioning, null, Collections.emptyMap());
        Set<PluginOption> pluginOptions = this.getPluginOptions(runtime);
        for (PluginOption opt : pluginOptions) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(opt.getName(), opt.isRequired(), opt.isAcceptsValue());
            options.add(dynOption);
        }
        return options;
    }

    protected abstract Set<PluginOption> getPluginOptions(ProvisioningRuntime var1) throws ProvisioningException;

    protected abstract Path getInstallationHome(AeshContext var1);

    private ProvisioningManager getManager(AeshContext ctx) {
        ProvisioningManager manager = ProvisioningManager.builder().setArtifactResolver(MavenArtifactRepositoryManager.getInstance()).setInstallationHome(this.getInstallationHome(ctx)).build();
        return manager;
    }

    protected ProvisioningManager getManager(PmCommandInvocation session) {
        return ProvisioningManager.builder().setArtifactResolver(MavenArtifactRepositoryManager.getInstance()).setInstallationHome(this.getInstallationHome(session.getAeshContext())).setMessageWriter(new DefaultMessageWriter(session.getOut(), session.getErr(), this.isVerbose())).build();
    }

    @Override
    protected String getId(PmSession session) {
        String streamName = (String)this.getValue("org.jboss.pm.tool.arg");
        String fpCoords = (String)this.getValue(FP_NAME);
        if (fpCoords == null && streamName == null) {
            String val = this.getArgumentValue();
            if (val == null) {
                return null;
            }
            streamName = val;
        }
        String coords = null;
        if (streamName != null) {
            try {
                coords = session.getUniverses().resolveStream(streamName).toString();
            }
            catch (ArtifactException artifactException) {}
        } else {
            coords = fpCoords;
        }
        return coords;
    }

    protected ArtifactCoords.Gav getGav(PmSession session) throws CommandExecutionException {
        String id = this.getId(session);
        if (id == null) {
            throw new CommandExecutionException("Stream resolution failed");
        }
        return ArtifactCoords.newGav(id);
    }
}

