/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractPathCompleter;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;
import org.jboss.galleon.cli.cmd.state.configuration.ConfigurationUtil;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;

public abstract class AbstractDefaultConfigCommand
extends AbstractFPProvisionedCommand {
    @Argument(required=true, description="Configuration name", completer=ConfigCompleter.class)
    private String configuration;
    @Option(completer=TargetedFPCompleter.class, description="configuration origin")
    protected String origin;

    protected String getConfiguration() {
        return this.configuration;
    }

    @Override
    public ArtifactCoords.Ga getGa(PmSession session) throws CommandExecutionException {
        if (this.origin == null) {
            return null;
        }
        return ArtifactCoords.newGav(this.origin).toGa();
    }

    public static class TargetedFPCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            State session = completerInvocation.getPmSession().getState();
            ArrayList<String> lst = new ArrayList<String>();
            if (session != null) {
                AbstractDefaultConfigCommand cmd = (AbstractDefaultConfigCommand)completerInvocation.getCommand();
                String config = cmd.getConfiguration();
                block0: for (Map.Entry<String, FeatureContainer> fp : session.getContainer().getFullDependencies().entrySet()) {
                    String[] split = config.split("/");
                    String model = split[0];
                    String name = split[1];
                    FeatureContainer container = fp.getValue();
                    List<ConfigInfo> confs = container.getFinalConfigs().get(model);
                    for (ConfigInfo ci : confs) {
                        if (!ci.getName().equals(name)) continue;
                        lst.add(fp.getKey());
                        continue block0;
                    }
                }
            }
            return lst;
        }
    }

    public static class ConfigCompleter
    extends AbstractPathCompleter {
        @Override
        protected FeatureContainer getContainer(PmCompleterInvocation completerInvocation) throws Exception {
            PmSession session = completerInvocation.getPmSession();
            return new AllConfigsContainer(session.getState().getContainer());
        }

        @Override
        protected String getCurrentPath(PmCompleterInvocation session) {
            return ConfigurationUtil.getCurrentPath(session.getPmSession());
        }

        @Override
        protected void filterCandidates(FeatureContainerPathConsumer consumer, List<String> candidates) {
            ConfigurationUtil.filterCandidates(consumer, candidates);
        }
    }

    private static class AllConfigsContainer
    extends FeatureContainer {
        private final FeatureContainer container;

        AllConfigsContainer(FeatureContainer container) {
            super(null, null);
            this.container = container;
        }

        @Override
        public Map<String, List<ConfigInfo>> getFinalConfigs() {
            HashMap<String, List<ConfigInfo>> map = new HashMap<String, List<ConfigInfo>>();
            for (FeatureContainer dep : this.container.getFullDependencies().values()) {
                for (String model : dep.getFinalConfigs().keySet()) {
                    ArrayList<ConfigInfo> lst = (ArrayList<ConfigInfo>)map.get(model);
                    if (lst == null) {
                        lst = new ArrayList<ConfigInfo>();
                        map.put(model, lst);
                    }
                    List<ConfigInfo> configs = dep.getFinalConfigs().get(model);
                    for (ConfigInfo ci : configs) {
                        if (lst.contains(ci)) continue;
                        lst.add(ci);
                    }
                }
            }
            return map;
        }
    }
}

