/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collection;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackDepsConfig
extends ConfigCustomizations {
    protected final Map<ArtifactCoords.Ga, FeaturePackConfig> fpDeps;
    protected final Map<String, FeaturePackConfig> fpDepsByOrigin;
    private final Map<ArtifactCoords.Ga, String> fpGaToOrigin;

    protected FeaturePackDepsConfig(FeaturePackDepsConfigBuilder<?> builder) {
        super(builder);
        this.fpDeps = CollectionUtils.unmodifiable(builder.fpDeps);
        this.fpDepsByOrigin = CollectionUtils.unmodifiable(builder.fpDepsByOrigin);
        this.fpGaToOrigin = builder.fpGaToOrigin;
    }

    public boolean hasFeaturePackDeps() {
        return !this.fpDeps.isEmpty();
    }

    public boolean hasFeaturePackDep(ArtifactCoords.Ga gaPart) {
        return this.fpDeps.containsKey(gaPart);
    }

    public FeaturePackConfig getFeaturePackDep(ArtifactCoords.Ga gaPart) {
        return this.fpDeps.get(gaPart);
    }

    public Collection<FeaturePackConfig> getFeaturePackDeps() {
        return this.fpDeps.values();
    }

    public FeaturePackConfig getFeaturePackDep(String origin) throws ProvisioningDescriptionException {
        FeaturePackConfig fpDep = this.fpDepsByOrigin.get(origin);
        if (fpDep == null) {
            throw new ProvisioningDescriptionException(Errors.unknownFeaturePackDependencyName(origin));
        }
        return fpDep;
    }

    public String originOf(ArtifactCoords.Ga fpGa) {
        return this.fpGaToOrigin.get(fpGa);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fpDeps == null ? 0 : this.fpDeps.hashCode());
        result = 31 * result + (this.fpDepsByOrigin == null ? 0 : this.fpDepsByOrigin.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackDepsConfig other = (FeaturePackDepsConfig)obj;
        if (this.fpDeps == null ? other.fpDeps != null : !this.fpDeps.equals(other.fpDeps)) {
            return false;
        }
        return !(this.fpDepsByOrigin == null ? other.fpDepsByOrigin != null : !this.fpDepsByOrigin.equals(other.fpDepsByOrigin));
    }
}

