/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.repomanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.repomanager.FeaturePackBuilder;

public class FeaturePackInstaller {
    private List<FeaturePackBuilder> fps = Collections.emptyList();
    private final ArtifactRepositoryManager outer;

    FeaturePackInstaller(ArtifactRepositoryManager outer) {
        this.outer = outer;
    }

    public FeaturePackBuilder newFeaturePack() {
        return this.newFeaturePack(null);
    }

    public FeaturePackBuilder newFeaturePack(ArtifactCoords.Gav gav) {
        FeaturePackBuilder fp = FeaturePackBuilder.newInstance(this);
        if (gav != null) {
            fp.setGav(gav);
        }
        this.addFeaturePack(fp);
        return fp;
    }

    public FeaturePackInstaller addFeaturePack(FeaturePackBuilder fp) {
        switch (this.fps.size()) {
            case 0: {
                this.fps = Collections.singletonList(fp);
                break;
            }
            case 1: {
                this.fps = new ArrayList<FeaturePackBuilder>(this.fps);
            }
            default: {
                this.fps.add(fp);
            }
        }
        return this;
    }

    public void install() throws ProvisioningDescriptionException {
        for (FeaturePackBuilder fp : this.fps) {
            fp.build(this.outer);
        }
    }
}

