/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.xml.FeatureSpecXmlParser;

public class FeaturePackRuntime
implements FeaturePack<PackageRuntime> {
    private final ProvisioningRuntime runtime;
    private final FeaturePackSpec spec;
    private final Path dir;
    private final Map<String, PackageRuntime> packages;
    private final Map<String, ResolvedFeatureSpec> featureSpecs;

    static FeaturePackRuntimeBuilder builder(FeaturePackSpec spec, Path dir) {
        return new FeaturePackRuntimeBuilder(spec, dir);
    }

    FeaturePackRuntime(FeaturePackRuntimeBuilder builder, ProvisioningRuntime runtime) throws ProvisioningException {
        this.runtime = runtime;
        this.spec = builder.spec;
        this.dir = builder.dir;
        this.featureSpecs = builder.featureSpecs;
        LinkedHashMap<String, PackageRuntime> tmpPackages = new LinkedHashMap<String, PackageRuntime>();
        for (String pkgName : builder.pkgOrder) {
            PackageRuntime.Builder pkgRtBuilder = builder.pkgBuilders.get(pkgName);
            tmpPackages.put(pkgName, pkgRtBuilder.build(this));
        }
        this.packages = Collections.unmodifiableMap(tmpPackages);
    }

    public ProvisioningRuntime getProvisioningRuntime() {
        return this.runtime;
    }

    public FeaturePackSpec getSpec() {
        return this.spec;
    }

    @Override
    public ArtifactCoords.Gav getGav() {
        return this.spec.getGav();
    }

    @Override
    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    @Override
    public boolean containsPackage(String name) {
        return this.packages.containsKey(name);
    }

    @Override
    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    @Override
    public Collection<PackageRuntime> getPackages() {
        return this.packages.values();
    }

    @Override
    public PackageRuntime getPackage(String name) {
        return this.packages.get(name);
    }

    public Set<String> getFeatureSpecNames() {
        return this.featureSpecs.keySet();
    }

    public Collection<ResolvedFeatureSpec> getFeatureSpecs() {
        return this.featureSpecs.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureSpec getFeatureSpec(String name) throws ProvisioningDescriptionException {
        if (this.featureSpecs.containsKey(name)) {
            return this.featureSpecs.get((Object)name).xmlSpec;
        }
        Path specXml = this.dir.resolve("features").resolve(name).resolve("spec.xml");
        if (!Files.exists(specXml, new LinkOption[0])) return null;
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            FeatureSpec featureSpec = FeatureSpecXmlParser.getInstance().parse(reader);
            return featureSpec;
        }
        catch (Exception e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(specXml), e);
        }
    }

    public ResolvedFeatureSpec getResolvedFeatureSpec(String name) throws ProvisioningDescriptionException {
        return this.featureSpecs.get(name);
    }

    public Path getResource(String ... path) throws ProvisioningDescriptionException {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.dir.resolve("resources").resolve(path[0]);
        }
        Path p = this.dir.resolve("resources");
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }
}

