/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.CollectionUtils;

class FpStack {
    private final ProvisioningConfig config;
    private List<Level> levels = new ArrayList<Level>();
    private Level lastPushed;
    private List<List<Level>> recordedStacks = Collections.emptyList();

    FpStack(ProvisioningConfig config) {
        this.config = config;
    }

    boolean push(FeaturePackConfig fpConfig, boolean extendCurrentLevel) {
        if (!this.isRelevant(fpConfig)) {
            return false;
        }
        if (extendCurrentLevel) {
            return this.lastPushed.addFpConfig(fpConfig);
        }
        Level newLevel = new Level();
        newLevel.addFpConfig(fpConfig);
        this.levels.add(newLevel);
        this.lastPushed = newLevel;
        return true;
    }

    void popLevel() {
        if (this.isEmpty()) {
            return;
        }
        if (this.levels.size() == 1) {
            this.levels.clear();
            this.lastPushed = null;
        } else {
            this.levels.remove(this.levels.size() - 1);
            this.lastPushed = this.levels.get(this.levels.size() - 1);
        }
    }

    boolean isEmpty() {
        return this.lastPushed == null;
    }

    boolean hasNext() {
        if (this.lastPushed == null) {
            return false;
        }
        return this.lastPushed.hasNext();
    }

    FeaturePackConfig next() {
        if (this.lastPushed == null) {
            throw new NoSuchElementException();
        }
        return this.lastPushed.next();
    }

    boolean isFilteredOut(ConfigId configId, boolean fromPrevLevel) {
        int i = this.levels.size() - (fromPrevLevel ? 2 : 1);
        while (i >= 0) {
            if (!this.levels.get(i--).isFilteredOut(configId)) continue;
            return true;
        }
        return FpStack.isFilteredOut(this.config, configId);
    }

    private static boolean isFilteredOut(ConfigCustomizations configCustoms, ConfigId configId) {
        if (configId.isAnonymous()) {
            return !configCustoms.isInheritConfigs();
        }
        if (configId.isModelOnly()) {
            return configCustoms.isConfigModelExcluded(configId) || !configCustoms.isInheritModelOnlyConfigs();
        }
        if (configCustoms.isInheritConfigs()) {
            if (configCustoms.isConfigExcluded(configId)) {
                return true;
            }
            if (configCustoms.isConfigModelExcluded(configId)) {
                return !configCustoms.isConfigIncluded(configId);
            }
            return false;
        }
        if (configCustoms.isConfigIncluded(configId)) {
            return false;
        }
        if (configCustoms.isConfigModelIncluded(configId)) {
            return configCustoms.isConfigExcluded(configId);
        }
        return true;
    }

    private boolean isRelevant(FeaturePackConfig fpConfig) {
        if (this.isEmpty()) {
            return true;
        }
        ArtifactCoords.Ga fpGa = fpConfig.getGav().toGa();
        Boolean pkgRelevancy = this.isInheritPackages(fpGa);
        if (pkgRelevancy == null) {
            return true;
        }
        if (pkgRelevancy.booleanValue()) {
            if (fpConfig.hasExcludedPackages()) {
                for (String excluded : fpConfig.getExcludedPackages()) {
                    if (this.isPackageExcluded(fpGa, excluded) || this.isPackageIncluded(fpGa, excluded)) continue;
                    return true;
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (PackageConfig included : fpConfig.getIncludedPackages()) {
                    if (this.isPackageIncluded(fpGa, included.getName()) || this.isPackageExcluded(fpGa, included.getName())) continue;
                    return true;
                }
            }
        }
        if (fpConfig.hasDefinedConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        if (fpConfig.hasModelOnlyConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritModelOnlyConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        return false;
    }

    private Boolean isInheritPackages(ArtifactCoords.Ga ga) {
        Boolean result = null;
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            Boolean levelResult = this.levels.get(i).isInheritPackages(ga);
            if (levelResult == null) continue;
            if (!levelResult.booleanValue()) {
                return false;
            }
            result = levelResult;
        }
        return result;
    }

    boolean isPackageExcluded(ArtifactCoords.Ga ga, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageExcluded(ga, packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPackageIncluded(ArtifactCoords.Ga ga, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageIncluded(ga, packageName)) continue;
            return true;
        }
        return false;
    }

    boolean isPackageFilteredOut(ArtifactCoords.Ga ga, String packageName, boolean fromPrevLevel) {
        Level level;
        Boolean filteredOut;
        int i = this.levels.size() - (fromPrevLevel ? 2 : 1);
        if (i < 0) {
            return false;
        }
        if ((filteredOut = (level = this.levels.get(i--)).isPackageFilteredOut(ga, packageName)) != null && filteredOut.booleanValue()) {
            return true;
        }
        while (i >= 0) {
            level = this.levels.get(i--);
            if (filteredOut == null && !level.isInheritPackages()) {
                return true;
            }
            filteredOut = level.isPackageFilteredOut(ga, packageName);
            if (filteredOut == null || !filteredOut.booleanValue()) continue;
            return true;
        }
        return filteredOut == null && !level.isInheritPackages();
    }

    void recordStack() {
        ArrayList<Level> copy = new ArrayList<Level>(this.levels.size());
        for (int i = 0; i < this.levels.size(); ++i) {
            copy.add(this.levels.get(i).copy());
        }
        this.recordedStacks = CollectionUtils.add(this.recordedStacks, copy);
    }

    void activateConfigStack(int i) throws ProvisioningException {
        if (this.recordedStacks.size() <= i) {
            throw new ProvisioningException("Stack index " + i + " is exceeding the current stack size " + this.recordedStacks.size());
        }
        this.levels = this.recordedStacks.get(i);
        this.lastPushed = this.levels.isEmpty() ? null : this.levels.get(this.levels.size() - 1);
    }

    private class Level {
        private List<FeaturePackConfig> fpConfigs = Collections.emptyList();
        private int currentFp = -1;

        private Level() {
        }

        Level copy() {
            Level copy = new Level();
            copy.fpConfigs = CollectionUtils.clone(this.fpConfigs);
            copy.currentFp = this.currentFp;
            return copy;
        }

        boolean addFpConfig(FeaturePackConfig fpConfig) {
            this.fpConfigs = CollectionUtils.add(this.fpConfigs, fpConfig);
            return true;
        }

        boolean hasNext() {
            return this.currentFp + 1 < this.fpConfigs.size();
        }

        FeaturePackConfig next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException(this.currentFp + 1 + " exceeded " + this.fpConfigs.size());
            }
            return this.fpConfigs.get(++this.currentFp);
        }

        boolean isFilteredOut(ConfigId configId) {
            return FpStack.isFilteredOut(this.fpConfigs.get(this.currentFp), configId);
        }

        boolean isInheritConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritConfigs();
        }

        boolean isInheritModelOnlyConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritModelOnlyConfigs();
        }

        boolean isInheritPackages() {
            return this.fpConfigs.get(this.currentFp).isInheritPackages();
        }

        Boolean isInheritPackages(ArtifactCoords.Ga ga) {
            FeaturePackConfig fpConfig = this.getFpConfig(ga);
            return fpConfig == null ? null : Boolean.valueOf(fpConfig.isInheritPackages());
        }

        boolean isPackageExcluded(ArtifactCoords.Ga ga, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(ga);
            return fpConfig == null ? false : fpConfig.isPackageExcluded(packageName);
        }

        boolean isPackageIncluded(ArtifactCoords.Ga ga, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(ga);
            return fpConfig == null ? false : fpConfig.isPackageIncluded(packageName);
        }

        Boolean isPackageFilteredOut(ArtifactCoords.Ga ga, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(ga);
            if (fpConfig == null) {
                return null;
            }
            if (fpConfig.isInheritPackages()) {
                return fpConfig.isPackageExcluded(packageName);
            }
            return !fpConfig.isPackageIncluded(packageName);
        }

        private FeaturePackConfig getFpConfig(ArtifactCoords.Ga ga) {
            for (int i = this.fpConfigs.size() - 1; i >= 0; --i) {
                FeaturePackConfig fpConfig = this.fpConfigs.get(i);
                if (!fpConfig.getGav().toGa().equals(ga)) continue;
                return fpConfig;
            }
            return null;
        }
    }
}

