/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.util.CollectionUtils;

public class FpVersionsResolver {
    private final ProvisioningRuntimeBuilder rt;
    private Set<ArtifactCoords.Ga> missingVersions = Collections.emptySet();
    private List<ArtifactCoords.Ga> branch = new ArrayList<ArtifactCoords.Ga>();
    private Map<ArtifactCoords.Ga, Set<ArtifactCoords.Gav>> conflicts = Collections.emptyMap();
    private Map<ArtifactCoords.Ga, FeaturePackRuntimeBuilder> loaded = Collections.emptyMap();

    static void resolveFpVersions(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        new FpVersionsResolver(rt).assertVersions();
    }

    static Map<ArtifactCoords.Ga, ArtifactCoords.Gav> resolveDeps(ProvisioningRuntimeBuilder rt, ArtifactCoords.Gav fpGav) throws ProvisioningException {
        return FpVersionsResolver.resolveDeps(rt, rt.getOrLoadFpBuilder((ArtifactCoords.Gav)fpGav).spec, Collections.emptyMap());
    }

    static Map<ArtifactCoords.Ga, ArtifactCoords.Gav> resolveDeps(ProvisioningRuntimeBuilder rt, FeaturePackDepsConfig fpDeps, Map<ArtifactCoords.Ga, ArtifactCoords.Gav> collected) throws ProvisioningException {
        if (!fpDeps.hasFeaturePackDeps()) {
            return collected;
        }
        for (FeaturePackConfig fpConfig : fpDeps.getFeaturePackDeps()) {
            int size = collected.size();
            if (size == (collected = CollectionUtils.put(collected, fpConfig.getGav().toGa(), fpConfig.getGav())).size()) continue;
            collected = FpVersionsResolver.resolveDeps(rt, rt.getOrLoadFpBuilder((ArtifactCoords.Gav)fpConfig.getGav()).spec, collected);
        }
        return collected;
    }

    private FpVersionsResolver(ProvisioningRuntimeBuilder rt) {
        this.rt = rt;
    }

    public boolean hasMissingVersions() {
        return !this.missingVersions.isEmpty();
    }

    public Set<ArtifactCoords.Ga> getMissingVersions() {
        return this.missingVersions;
    }

    public boolean hasVersionConflicts() {
        return !this.conflicts.isEmpty();
    }

    public Map<ArtifactCoords.Ga, Set<ArtifactCoords.Gav>> getVersionConflicts() {
        return this.conflicts;
    }

    private void assertVersions() throws ProvisioningException {
        this.assertVersions(this.rt.config);
        if (!this.missingVersions.isEmpty() || !this.conflicts.isEmpty()) {
            throw new ProvisioningDescriptionException(Errors.fpVersionCheckFailed(this.missingVersions, this.conflicts.values()));
        }
    }

    private void assertVersions(FeaturePackDepsConfig fpDepsConfig) throws ProvisioningException {
        ArtifactCoords.Gav gav;
        if (!fpDepsConfig.hasFeaturePackDeps()) {
            return;
        }
        int branchSize = this.branch.size();
        Collection<FeaturePackConfig> fpDeps = fpDepsConfig.getFeaturePackDeps();
        Set<Object> skip = Collections.emptySet();
        for (FeaturePackConfig fpConfig : fpDeps) {
            gav = fpConfig.getGav();
            if (gav.getVersion() == null) {
                this.missingVersions = CollectionUtils.addLinked(this.missingVersions, gav.toGa());
                continue;
            }
            FeaturePackRuntimeBuilder fp = this.loaded.get(gav.toGa());
            if (fp != null) {
                if (!fp.gav.equals(gav) && !this.branch.contains(gav.toGa())) {
                    Set<ArtifactCoords.Gav> versions = this.conflicts.get(fp.gav.toGa());
                    if (versions != null) {
                        versions.add(gav);
                        continue;
                    }
                    versions = new LinkedHashSet<ArtifactCoords.Gav>();
                    versions.add(fp.gav);
                    versions.add(gav);
                    this.conflicts = CollectionUtils.putLinked(this.conflicts, gav.toGa(), versions);
                }
                skip = CollectionUtils.add(skip, fp.gav);
                continue;
            }
            this.load(gav);
            if (!this.missingVersions.isEmpty()) {
                this.missingVersions = CollectionUtils.remove(this.missingVersions, gav.toGa());
            }
            this.branch.add(gav.toGa());
        }
        for (FeaturePackConfig fpConfig : fpDeps) {
            gav = fpConfig.getGav();
            if (gav.getVersion() == null || skip.contains(gav)) continue;
            this.assertVersions(this.rt.getFpBuilder((ArtifactCoords.Gav)gav, (boolean)true).spec);
        }
        for (int i = 0; i < this.branch.size() - branchSize; ++i) {
            this.branch.remove(this.branch.size() - 1);
        }
    }

    private FeaturePackRuntimeBuilder load(ArtifactCoords.Gav gav) throws ProvisioningException {
        FeaturePackRuntimeBuilder fp = this.rt.getOrLoadFpBuilder(gav);
        this.loaded = CollectionUtils.put(this.loaded, gav.toGa(), fp);
        return fp;
    }
}

