/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.state.ProvisionedPackage;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisionedFeaturePack
implements FeaturePack<ProvisionedPackage> {
    private final ArtifactCoords.Gav gav;
    private final Map<String, ProvisionedPackage> packages;

    public static Builder builder(ArtifactCoords.Gav gav) {
        return new Builder(gav);
    }

    public static ProvisionedFeaturePack forGav(ArtifactCoords.Gav gav) {
        return new ProvisionedFeaturePack(gav, Collections.emptyMap());
    }

    ProvisionedFeaturePack(ArtifactCoords.Gav gav, Map<String, ProvisionedPackage> packages) {
        this.gav = gav;
        this.packages = packages;
    }

    @Override
    public ArtifactCoords.Gav getGav() {
        return this.gav;
    }

    @Override
    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    @Override
    public boolean containsPackage(String name) {
        return this.packages.containsKey(name);
    }

    @Override
    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    @Override
    public Collection<ProvisionedPackage> getPackages() {
        return this.packages.values();
    }

    @Override
    public ProvisionedPackage getPackage(String name) {
        return this.packages.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.gav == null ? 0 : this.gav.hashCode());
        result = 31 * result + (this.packages == null ? 0 : this.packages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedFeaturePack other = (ProvisionedFeaturePack)obj;
        if (this.gav == null ? other.gav != null : !this.gav.equals(other.gav)) {
            return false;
        }
        return !(this.packages == null ? other.packages != null : !this.packages.equals(other.packages));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[').append(this.gav);
        if (!this.packages.isEmpty()) {
            buf.append(' ');
            StringUtils.append(buf, this.packages.values());
        }
        return buf.append(']').toString();
    }

    public static class Builder {
        private ArtifactCoords.Gav gav;
        private Map<String, ProvisionedPackage> packages = Collections.emptyMap();

        private Builder(ArtifactCoords.Gav gav) {
            this.gav = gav;
        }

        public Builder addPackage(String name) {
            return this.addPackage(ProvisionedPackage.newInstance(name));
        }

        public Builder addPackage(ProvisionedPackage provisionedPkg) {
            this.packages = CollectionUtils.putLinked(this.packages, provisionedPkg.getName(), provisionedPkg);
            return this;
        }

        public boolean hasPackage(String name) {
            return this.packages.containsKey(name);
        }

        public ProvisionedFeaturePack build() {
            return new ProvisionedFeaturePack(this.gav, CollectionUtils.unmodifiable(this.packages));
        }
    }
}

