/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityProviders;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.runtime.CircularRefInfo;
import org.jboss.galleon.runtime.ConfigFeatureBranch;
import org.jboss.galleon.runtime.ConfigModelStack;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.util.CollectionUtils;

class DefaultBranchedConfigArranger {
    private final ConfigModelStack configStack;
    private final Map<ResolvedSpecId, SpecFeatures> specFeatures;
    private final Map<ResolvedFeatureId, ResolvedFeature> features;
    private final boolean branchPerSpec;
    private final boolean branchIsBatch;
    private final boolean isolateCircularDeps;
    private final boolean mergeIndependentBranches;
    private CapabilityResolver capResolver = new CapabilityResolver();
    private Map<String, CapabilityProviders> capProviders = Collections.emptyMap();
    private List<ConfigFeatureBranch> featureBranches = Collections.emptyList();
    private Map<Object, ConfigFeatureBranch> branchesWithId = Collections.emptyMap();
    private ConfigFeatureBranch currentBranch;
    private boolean orderReferencedSpec;
    private boolean onParentChildrenBranch;
    private boolean circularDeps;
    private Map<List<String>, List<ResolvedFeature>> branchesByDeps = Collections.emptyMap();
    private List<ResolvedFeature> orderedFeatures = Collections.emptyList();
    private List<ResolvedFeature> independentBatchBranch = Collections.emptyList();
    private List<ResolvedFeature> independentNonBatchBranch = Collections.emptyList();

    private static boolean getBooleanProp(Map<String, String> props, String name, boolean defaultValue) {
        String value = props.get(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    DefaultBranchedConfigArranger(ConfigModelStack configStack) {
        this.configStack = configStack;
        this.specFeatures = configStack.specFeatures;
        this.features = configStack.features;
        this.orderReferencedSpec = this.branchPerSpec = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.branch-per-spec", false);
        this.branchIsBatch = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.branch-is-batch", false);
        this.isolateCircularDeps = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.isolate-circular-deps", false);
        this.mergeIndependentBranches = DefaultBranchedConfigArranger.getBooleanProp(configStack.props, "config.merge-independent-branches", false);
    }

    List<ResolvedFeature> orderFeatures() throws ProvisioningException {
        try {
            this.doOrder(this.configStack.rt);
        }
        catch (ProvisioningException e) {
            throw new ProvisioningException(Errors.failedToBuildConfigSpec(this.configStack.id.getModel(), this.configStack.id.getName()), e);
        }
        this.orderedFeatures = new ArrayList<ResolvedFeature>(this.features.size());
        if (DefaultBranchedConfigArranger.getBooleanProp(this.configStack.props, "config.merge-same-deps-branches", false)) {
            this.branchesByDeps = new LinkedHashMap<List<String>, List<ResolvedFeature>>(this.featureBranches.size());
            for (ConfigFeatureBranch configFeatureBranch : this.featureBranches) {
                this.orderAndMergeBranchesWithSameDeps(configFeatureBranch);
            }
            for (List list : this.branchesByDeps.values()) {
                if (list.size() == 1) {
                    ResolvedFeature feature = (ResolvedFeature)list.get(0);
                    if (feature.isBatchStart()) {
                        feature.clearBatchStart();
                        feature.clearBatchEnd();
                    }
                    this.orderedFeatures.add(feature);
                    continue;
                }
                this.orderedFeatures.addAll(list);
            }
            return this.orderedFeatures;
        }
        for (ConfigFeatureBranch configFeatureBranch : this.featureBranches) {
            this.orderBranches(configFeatureBranch);
        }
        if (!this.mergeIndependentBranches) {
            return this.orderedFeatures;
        }
        ArrayList<ResolvedFeature> result = new ArrayList<ResolvedFeature>(this.features.size());
        if (!this.independentNonBatchBranch.isEmpty()) {
            result.addAll(this.independentNonBatchBranch);
        }
        if (!this.independentBatchBranch.isEmpty()) {
            if (this.independentBatchBranch.size() == 1) {
                ResolvedFeature resolvedFeature = this.independentBatchBranch.get(0);
                resolvedFeature.clearBatchStart();
                resolvedFeature.clearBatchEnd();
            } else {
                this.independentBatchBranch.get(0).startBatch();
                this.independentBatchBranch.get(this.independentBatchBranch.size() - 1).endBatch();
            }
            result.addAll(this.independentBatchBranch);
        }
        result.addAll(this.orderedFeatures);
        return result;
    }

    private void orderBranches(ConfigFeatureBranch branch) {
        if (branch.isOrdered() || branch.isEmpty()) {
            return;
        }
        if (branch.hasDeps()) {
            for (ConfigFeatureBranch dep : branch.getDeps()) {
                this.orderBranches(dep);
            }
            branch.ordered();
            this.orderedFeatures.addAll(branch.getFeatures());
        } else if (this.mergeIndependentBranches) {
            branch.ordered();
            if (branch.isBatch()) {
                if (this.independentBatchBranch.isEmpty()) {
                    this.independentBatchBranch = new ArrayList<ResolvedFeature>();
                } else {
                    ResolvedFeature firstOnBranch = branch.getFeatures().get(0);
                    firstOnBranch.clearStartBranch();
                    firstOnBranch.clearBatchStart();
                    ResolvedFeature lastOnBranch = this.independentBatchBranch.get(this.independentBatchBranch.size() - 1);
                    lastOnBranch.clearEndBranch();
                    lastOnBranch.clearBatchEnd();
                }
                this.independentBatchBranch.addAll(branch.getFeatures());
            } else {
                if (this.independentNonBatchBranch.isEmpty()) {
                    this.independentNonBatchBranch = new ArrayList<ResolvedFeature>();
                } else {
                    ResolvedFeature firstOnBranch = branch.getFeatures().get(0);
                    firstOnBranch.clearStartBranch();
                    ResolvedFeature lastOnBranch = this.independentNonBatchBranch.get(this.independentNonBatchBranch.size() - 1);
                    lastOnBranch.clearEndBranch();
                }
                this.independentNonBatchBranch.addAll(branch.getFeatures());
            }
        } else {
            branch.ordered();
            this.orderedFeatures.addAll(branch.getFeatures());
        }
    }

    private void orderAndMergeBranchesWithSameDeps(ConfigFeatureBranch branch) {
        List<Object> depsId;
        if (branch.isOrdered() || branch.isEmpty()) {
            return;
        }
        Set<ConfigFeatureBranch> branchDeps = branch.getDeps();
        if (!branchDeps.isEmpty()) {
            for (ConfigFeatureBranch dep : branchDeps) {
                this.orderAndMergeBranchesWithSameDeps(dep);
            }
        }
        branch.ordered();
        switch (branchDeps.size()) {
            case 0: {
                depsId = Collections.emptyList();
                break;
            }
            case 1: {
                depsId = Collections.singletonList(branchDeps.iterator().next().id.toString());
                break;
            }
            default: {
                Object[] arr = new String[branchDeps.size()];
                int i = 0;
                for (ConfigFeatureBranch branchDep : branchDeps) {
                    arr[i++] = branchDep.id.toString();
                }
                Arrays.sort(arr);
                depsId = Arrays.asList(arr);
            }
        }
        List<ResolvedFeature> features = this.branchesByDeps.get(depsId);
        if (features == null) {
            List<ResolvedFeature> branchFeatures = branch.getFeatures();
            this.branchesByDeps.put(depsId, new ArrayList<ResolvedFeature>(branchFeatures));
            if (branch.isBatch()) {
                branchFeatures.get(0).startBatch();
                branchFeatures.get(branchFeatures.size() - 1).endBatch();
            }
        } else {
            ResolvedFeature lastFeature = features.get(features.size() - 1);
            lastFeature.clearEndBranch();
            List<ResolvedFeature> branchFeatures = branch.getFeatures();
            ResolvedFeature firstFeature = branchFeatures.get(0);
            firstFeature.clearStartBranch();
            if (branch.isBatch()) {
                if (lastFeature.isBatchEnd()) {
                    lastFeature.clearBatchEnd();
                    firstFeature.clearBatchStart();
                } else {
                    firstFeature.startBatch();
                }
                branchFeatures.get(branchFeatures.size() - 1).endBatch();
            }
            features.addAll(branchFeatures);
        }
    }

    private void doOrder(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        for (SpecFeatures specFeatures : this.specFeatures.values()) {
            specFeatures.spec.resolveRefMappings(rt);
            if (!specFeatures.spec.xmlSpec.providesCapabilities()) continue;
            for (CapabilitySpec cap : specFeatures.spec.xmlSpec.getProvidedCapabilities()) {
                if (cap.isStatic()) {
                    this.getProviders(cap.toString(), true).add(specFeatures);
                    continue;
                }
                for (ResolvedFeature feature : specFeatures.getFeatures()) {
                    List<String> resolvedCaps = this.capResolver.resolve(cap, feature);
                    if (resolvedCaps.isEmpty()) continue;
                    for (String resolvedCap : resolvedCaps) {
                        this.getProviders(resolvedCap, true).add(feature);
                    }
                }
            }
        }
        this.featureBranches = new ArrayList<ConfigFeatureBranch>();
        if (this.branchPerSpec) {
            for (SpecFeatures features : this.specFeatures.values()) {
                this.orderFeaturesInSpec(features, false);
            }
        } else {
            for (ResolvedFeature feature : this.features.values()) {
                this.orderFeature(feature);
            }
        }
    }

    private CapabilityProviders getProviders(String cap, boolean add) throws ProvisioningException {
        CapabilityProviders providers = this.capProviders.get(cap);
        if (providers != null) {
            return providers;
        }
        if (!add) {
            throw new ProvisioningException(Errors.noCapabilityProvider(cap));
        }
        providers = new CapabilityProviders();
        this.capProviders = CollectionUtils.put(this.capProviders, cap, providers);
        return providers;
    }

    private List<CircularRefInfo> orderFeaturesInSpec(SpecFeatures specFeatures, boolean force) throws ProvisioningException {
        if (!force) {
            if (!specFeatures.isFree()) {
                return null;
            }
            specFeatures.schedule();
        }
        List<CircularRefInfo> allCircularRefs = null;
        int i = 0;
        List<ResolvedFeature> features = specFeatures.getFeatures();
        while (i < features.size() && allCircularRefs == null) {
            if (this.onParentChildrenBranch) {
                this.onParentChildrenBranch = false;
                this.startNewBranch(null, this.branchIsBatch);
            }
            allCircularRefs = this.orderFeature(features.get(i++));
        }
        if (!force) {
            specFeatures.free();
        }
        return allCircularRefs;
    }

    /*
     * WARNING - void declaration
     */
    private List<CircularRefInfo> orderFeature(ResolvedFeature feature) throws ProvisioningException {
        List<ResolvedFeatureId> refIds;
        if (feature.isOrdered()) {
            return null;
        }
        if (!feature.isFree()) {
            return Collections.singletonList(new CircularRefInfo(feature));
        }
        feature.schedule();
        List<CircularRefInfo> circularRefs = Collections.emptyList();
        if (feature.spec.xmlSpec.requiresCapabilities()) {
            circularRefs = this.orderCapabilityProviders(feature, circularRefs);
        }
        if (!feature.deps.isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, feature.deps.keySet(), false, circularRefs);
        }
        if (!(refIds = feature.resolveRefs()).isEmpty()) {
            circularRefs = this.orderReferencedFeatures(feature, refIds, true, circularRefs);
        }
        List<Object> initiatedCircularRefs = Collections.emptyList();
        if (!circularRefs.isEmpty()) {
            if (circularRefs.size() == 1) {
                CircularRefInfo next = circularRefs.get(0);
                if (next.loopedOn.id.equals(feature.id)) {
                    circularRefs = Collections.emptyList();
                    initiatedCircularRefs = Collections.singletonList(next);
                } else {
                    next.setNext(feature);
                    feature.free();
                }
            } else {
                Iterator<CircularRefInfo> i = circularRefs.iterator();
                while (i.hasNext()) {
                    CircularRefInfo next = i.next();
                    if (next.loopedOn.id.equals(feature.id)) {
                        i.remove();
                        initiatedCircularRefs = CollectionUtils.add(initiatedCircularRefs, next);
                        continue;
                    }
                    next.setNext(feature);
                    feature.free();
                }
            }
            if (!circularRefs.isEmpty()) {
                return circularRefs;
            }
        }
        if (!initiatedCircularRefs.isEmpty()) {
            boolean prevOrderRefSpec = this.orderReferencedSpec;
            this.orderReferencedSpec = false;
            initiatedCircularRefs.sort(CircularRefInfo.getFirstInConfigComparator());
            if (((CircularRefInfo)initiatedCircularRefs.get((int)0)).firstInConfig.includeNo < feature.includeNo) {
                feature.free();
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.firstInConfig) == null) continue;
                    throw new IllegalStateException();
                }
            } else {
                void var7_14;
                boolean originalCircularDeps = this.circularDeps;
                this.circularDeps = true;
                boolean bl = false;
                if (!originalCircularDeps) {
                    boolean newBranch = false;
                    Object var9_17 = null;
                    if (this.isolateCircularDeps) {
                        newBranch = true;
                        boolean bl2 = true;
                    } else if (this.currentBranch == null) {
                        newBranch = true;
                        boolean bl3 = !this.branchIsBatch;
                        String string = feature.spec.branchId;
                    } else if (this.currentBranch.anonymous) {
                        if (feature.spec.branchId != null) {
                            newBranch = true;
                            String string = feature.spec.branchId;
                        } else if (!this.currentBranch.isBatch()) {
                            newBranch = true;
                            boolean bl4 = !this.branchIsBatch;
                        }
                    } else if (!this.currentBranch.id.equals(feature.spec.branchId)) {
                        newBranch = true;
                        String string = feature.spec.branchId;
                    }
                    if (newBranch) {
                        void var9_21;
                        this.startNewBranch(var9_21, true);
                    }
                }
                this.determineBranch(feature).add(feature);
                initiatedCircularRefs.sort(CircularRefInfo.getNextOnPathComparator());
                for (CircularRefInfo circularRefInfo : initiatedCircularRefs) {
                    if (this.orderFeature(circularRefInfo.nextOnPath) == null) continue;
                    throw new IllegalStateException();
                }
                if (var7_14 != false) {
                    this.startNewBranch(null, this.branchIsBatch);
                }
                this.circularDeps = originalCircularDeps;
            }
            this.orderReferencedSpec = prevOrderRefSpec;
        } else {
            this.determineBranch(feature).add(feature);
        }
        return null;
    }

    private ConfigFeatureBranch determineBranch(ResolvedFeature feature) throws ProvisioningException {
        if (this.circularDeps) {
            if (this.currentBranch == null) {
                throw new IllegalStateException("current branch is null");
            }
            if (feature.spec.parentChildrenBranch) {
                this.currentBranch.setFkBranch();
            }
            return this.currentBranch;
        }
        if (!feature.branchDeps.isEmpty()) {
            Map.Entry<ConfigFeatureBranch, Boolean> next;
            Iterator<Map.Entry<ConfigFeatureBranch, Boolean>> branchDepIter = feature.branchDeps.entrySet().iterator();
            if (feature.branchDeps.size() == 1 && (next = branchDepIter.next()).getValue().booleanValue() && next.getKey().isFkBranch()) {
                return next.getKey();
            }
            while (branchDepIter.hasNext()) {
                ConfigFeatureBranch candidate;
                next = branchDepIter.next();
                if (!next.getValue().booleanValue() || !next.getKey().isFkBranch() || this.createsDepCircle(candidate = next.getKey(), feature)) continue;
                return candidate;
            }
        }
        ConfigFeatureBranch branch = null;
        if (feature.spec.isSpecBranch(this.branchPerSpec)) {
            SpecFeatures spec = feature.getSpecFeatures();
            ConfigFeatureBranch configFeatureBranch = spec.isBranchSet() ? spec.getBranch() : (branch = spec.spec.branchId == null ? null : this.branchesWithId.get(spec.spec.branchId));
            if (branch == null) {
                branch = this.startNewBranch(spec.spec.branchId, feature.spec.isBatchBranch(this.branchIsBatch));
                spec.setBranch(branch);
            } else if (this.createsDepCircle(branch, feature)) {
                branch = this.startNewBranch(null, this.branchIsBatch);
            } else if (!spec.isBranchSet()) {
                spec.setBranch(branch);
            }
        }
        if (feature.spec.parentChildrenBranch) {
            if (branch == null) {
                branch = this.startNewBranch(null, feature.spec.isBatchBranch(this.branchIsBatch));
            }
            branch.setFkBranch();
            this.onParentChildrenBranch = true;
            return branch;
        }
        if (branch != null) {
            return branch;
        }
        if (this.currentBranch == null || this.currentBranch.isSpecBranch() || this.currentBranch.isFkBranch() || this.createsDepCircle(this.currentBranch, feature)) {
            this.startNewBranch(null, feature.spec.isBatchBranch(this.branchIsBatch));
        }
        return this.currentBranch;
    }

    private boolean createsDepCircle(ConfigFeatureBranch branch, ResolvedFeature feature) {
        if (branch.isEmpty() || feature.branchDeps.isEmpty()) {
            return false;
        }
        HashSet<ConfigFeatureBranch> visitedBranches = null;
        for (ConfigFeatureBranch newDep : feature.branchDeps.keySet()) {
            if (newDep.id.equals(branch.id) || branch.dependsOn(newDep)) continue;
            if (newDep.dependsOn(branch)) {
                return true;
            }
            if (visitedBranches == null) {
                visitedBranches = new HashSet<ConfigFeatureBranch>();
                visitedBranches.add(branch);
            }
            if (!this.createsDepCircle(newDep, visitedBranches)) continue;
            return true;
        }
        return false;
    }

    private boolean createsDepCircle(ConfigFeatureBranch next, Set<ConfigFeatureBranch> visitedBranches) {
        if (!next.hasDeps()) {
            return false;
        }
        visitedBranches.add(next);
        for (ConfigFeatureBranch newDep : next.getDeps()) {
            if (visitedBranches.contains(newDep)) {
                return true;
            }
            if (!this.createsDepCircle(newDep, visitedBranches)) continue;
            return true;
        }
        visitedBranches.remove(next);
        return false;
    }

    private ConfigFeatureBranch startNewBranch(Object id, boolean batch) throws ProvisioningException {
        if (this.currentBranch != null && this.currentBranch.isEmpty() && (this.currentBranch.anonymous && id == null || id != null && id.equals(this.currentBranch.id))) {
            if (this.currentBranch.isBatch() == batch) {
                return this.currentBranch;
            }
            this.currentBranch.setBatch(batch);
            return this.currentBranch;
        }
        if (id == null) {
            this.currentBranch = new ConfigFeatureBranch(this.featureBranches.size(), batch);
        } else if (this.branchesWithId.isEmpty()) {
            this.branchesWithId = new HashMap<Object, ConfigFeatureBranch>();
            this.currentBranch = new ConfigFeatureBranch(id, batch);
            this.branchesWithId.put(id, this.currentBranch);
        } else {
            this.currentBranch = this.branchesWithId.get(id);
            if (this.currentBranch == null) {
                this.currentBranch = new ConfigFeatureBranch(id, batch);
                this.branchesWithId.put(id, this.currentBranch);
            } else {
                return this.currentBranch;
            }
        }
        this.featureBranches.add(this.currentBranch);
        return this.currentBranch;
    }

    private List<CircularRefInfo> orderCapabilityProviders(ResolvedFeature feature, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (CapabilitySpec capSpec : feature.spec.xmlSpec.getRequiredCapabilities()) {
            List<String> resolvedCaps = this.capResolver.resolve(capSpec, feature);
            if (resolvedCaps.isEmpty()) continue;
            for (String resolvedCap : resolvedCaps) {
                CapabilityProviders providers;
                try {
                    providers = this.getProviders(resolvedCap, false);
                }
                catch (ProvisioningException e) {
                    throw new ProvisioningException(Errors.noCapabilityProvider(feature, capSpec, resolvedCap));
                }
                circularRefs = CollectionUtils.addAll(circularRefs, this.orderProviders(providers));
                if (providers.isProvided()) {
                    feature.addBranchDep(providers.branches.iterator().next(), false);
                    continue;
                }
                providers.addBranchDependee(feature);
            }
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderProviders(CapabilityProviders providers) throws ProvisioningException {
        List<CircularRefInfo> loop;
        if (providers.isProvided()) {
            return Collections.emptyList();
        }
        List<CircularRefInfo> firstLoop = null;
        if (!providers.specs.isEmpty()) {
            Iterator<Object> iterator = providers.specs.iterator();
            while (iterator.hasNext()) {
                SpecFeatures specFeatures;
                loop = this.orderFeaturesInSpec(specFeatures, !(specFeatures = iterator.next()).isFree());
                if (providers.isProvided()) {
                    return Collections.emptyList();
                }
                if (firstLoop != null) continue;
                firstLoop = loop;
            }
        }
        if (!providers.features.isEmpty()) {
            for (ResolvedFeature provider : providers.features) {
                loop = this.orderFeature(provider);
                if (providers.isProvided()) {
                    return Collections.emptyList();
                }
                if (firstLoop != null) continue;
                firstLoop = loop;
            }
        }
        return firstLoop == null ? Collections.emptyList() : firstLoop;
    }

    private List<CircularRefInfo> orderReferencedFeatures(ResolvedFeature feature, Collection<ResolvedFeatureId> refIds, boolean specRefs, List<CircularRefInfo> circularRefs) throws ProvisioningException {
        for (ResolvedFeatureId refId : refIds) {
            List<CircularRefInfo> newCircularRefs = this.orderReferencedFeature(feature, refId, specRefs);
            if (newCircularRefs == null) continue;
            circularRefs = CollectionUtils.addAll(circularRefs, newCircularRefs);
        }
        return circularRefs;
    }

    private List<CircularRefInfo> orderReferencedFeature(ResolvedFeature feature, ResolvedFeatureId refId, boolean specRef) throws ProvisioningException {
        ResolvedFeature dep;
        if (this.orderReferencedSpec && specRef && !feature.spec.id.equals(refId.specId)) {
            SpecFeatures targetSpecFeatures = this.specFeatures.get(refId.specId);
            if (targetSpecFeatures == null) {
                throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
            }
            List<CircularRefInfo> specLoops = this.orderFeaturesInSpec(targetSpecFeatures, false);
            if (specLoops != null) {
                List<CircularRefInfo> featureLoops = null;
                for (int i = 0; i < specLoops.size(); ++i) {
                    CircularRefInfo specLoop = specLoops.get(i);
                    if (!specLoop.nextOnPath.id.equals(refId)) continue;
                    if (featureLoops == null) {
                        featureLoops = Collections.singletonList(specLoop);
                        continue;
                    }
                    if (featureLoops.size() == 1) {
                        CircularRefInfo first = featureLoops.get(0);
                        featureLoops = new ArrayList<CircularRefInfo>(2);
                        featureLoops.add(first);
                    }
                    featureLoops.add(specLoop);
                }
                if (featureLoops != null) {
                    return featureLoops;
                }
            }
        }
        if ((dep = this.features.get(refId)) == null) {
            throw new ProvisioningDescriptionException(Errors.unresolvedFeatureDep(feature, refId));
        }
        List<CircularRefInfo> circularRefs = this.orderFeature(dep);
        if (dep.branch != null) {
            feature.addBranchDep(dep.branch, refId.isChildRef());
        } else {
            dep.addBranchDependee(feature);
        }
        return circularRefs;
    }

    private void dumpBranches() {
        Path file = Paths.get(System.getProperty("user.home"), new String[0]).resolve("galleon-scripts").resolve("branches-" + this.configStack.id.getName());
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            if (!this.independentNonBatchBranch.isEmpty()) {
                this.dumpBranch(writer, this.independentNonBatchBranch, "Independent non-batch branch");
            }
            if (!this.independentBatchBranch.isEmpty()) {
                this.dumpBranch(writer, this.independentBatchBranch, "Independent batch branch");
            }
            int i = 1;
            for (ConfigFeatureBranch branch : this.featureBranches) {
                this.dumpBranch(writer, branch.getFeatures(), "Branch " + i++ + " id=" + branch.id + " batch=" + branch.isBatch());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpBranch(BufferedWriter writer, List<ResolvedFeature> features, String branchTitle) throws IOException {
        writer.write(branchTitle);
        writer.newLine();
        int j = 1;
        for (ResolvedFeature feature : features) {
            writer.write("    " + j++ + ". " + feature.getId());
            if (feature.isBatchStart()) {
                writer.write(" start batch");
            }
            if (feature.isBatchEnd()) {
                writer.write(" end batch");
            }
            writer.newLine();
        }
    }
}

