/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.type.ParameterTypeProvider;
import org.jboss.galleon.type.builtin.BuiltInParameterTypeProvider;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.xml.FeatureGroupXmlParser;
import org.jboss.galleon.xml.FeatureSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser;

class FeaturePackRuntimeBuilder {
    final ArtifactCoords.Gav gav;
    final Path dir;
    final FeaturePackSpec spec;
    boolean ordered;
    Map<String, ResolvedFeatureSpec> featureSpecs = null;
    private Map<String, FeatureGroup> fgSpecs = null;
    Map<String, PackageRuntime.Builder> pkgBuilders = Collections.emptyMap();
    List<String> pkgOrder = new ArrayList<String>();
    private ParameterTypeProvider featureParamTypeProvider = BuiltInParameterTypeProvider.getInstance();

    FeaturePackRuntimeBuilder(FeaturePackSpec spec, Path dir) {
        this.gav = spec.getGav();
        this.dir = dir;
        this.spec = spec;
    }

    boolean resolvePackage(String pkgName, ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        PackageRuntime.Builder pkgBuilder;
        if (this.pkgBuilders.containsKey(pkgName)) {
            return true;
        }
        Path pkgDir = LayoutUtils.getPackageDir(this.dir, pkgName, false);
        if (!Files.exists(pkgDir, new LinkOption[0])) {
            return false;
        }
        Path pkgXml = pkgDir.resolve("package.xml");
        if (!Files.exists(pkgXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(Errors.pathDoesNotExist(pkgXml));
        }
        try (BufferedReader reader = Files.newBufferedReader(pkgXml);){
            pkgBuilder = PackageRuntime.builder(PackageXmlParser.getInstance().parse(reader), pkgDir);
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(pkgXml), e);
        }
        this.pkgBuilders = CollectionUtils.put(this.pkgBuilders, pkgName, pkgBuilder);
        if (pkgBuilder.spec.hasPackageDeps()) {
            try {
                rt.processPackageDeps(pkgBuilder.spec);
            }
            catch (ProvisioningException e) {
                throw new ProvisioningDescriptionException(Errors.resolvePackage(this.gav, pkgName), e);
            }
        }
        this.pkgOrder.add(pkgName);
        if (!this.ordered) {
            rt.orderFpRtBuilder(this);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FeatureGroup getFeatureGroupSpec(String name) throws ProvisioningException {
        FeatureGroup fgSpec;
        if (this.fgSpecs != null && (fgSpec = this.fgSpecs.get(name)) != null) {
            return fgSpec;
        }
        Path specXml = this.dir.resolve("feature_groups").resolve(name + ".xml");
        if (!Files.exists(specXml, new LinkOption[0])) return null;
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            FeatureGroup fgSpec2 = FeatureGroupXmlParser.getInstance().parse(reader);
            if (this.fgSpecs == null) {
                this.fgSpecs = new HashMap<String, FeatureGroup>();
            }
            this.fgSpecs.put(name, fgSpec2);
            FeatureGroup featureGroup = fgSpec2;
            return featureGroup;
        }
        catch (Exception e) {
            throw new ProvisioningException(Errors.parseXml(specXml), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResolvedFeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        ResolvedFeatureSpec resolvedSpec;
        if (this.featureSpecs != null && (resolvedSpec = this.featureSpecs.get(name)) != null) {
            return resolvedSpec;
        }
        Path specXml = this.dir.resolve("features").resolve(name).resolve("spec.xml");
        if (!Files.exists(specXml, new LinkOption[0])) return null;
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            FeatureSpec xmlSpec = FeatureSpecXmlParser.getInstance().parse(reader);
            ResolvedFeatureSpec resolvedSpec2 = new ResolvedFeatureSpec(new ResolvedSpecId(this.gav, xmlSpec.getName()), this.featureParamTypeProvider, xmlSpec);
            if (this.featureSpecs == null) {
                this.featureSpecs = new HashMap<String, ResolvedFeatureSpec>();
            }
            this.featureSpecs.put(name, resolvedSpec2);
            ResolvedFeatureSpec resolvedFeatureSpec = resolvedSpec2;
            return resolvedFeatureSpec;
        }
        catch (Exception e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(specXml), e);
        }
    }

    FeaturePackRuntime build(ProvisioningRuntime runtime) throws ProvisioningException {
        return new FeaturePackRuntime(this, runtime);
    }
}

