/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlParser10;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.TextNode;

public class ProvisioningXmlWriter
extends BaseXmlWriter<ProvisioningConfig> {
    private static final ProvisioningXmlWriter INSTANCE = new ProvisioningXmlWriter();
    private static final String FALSE = "false";

    public static ProvisioningXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisioningXmlWriter() {
    }

    @Override
    protected ElementNode toElement(ProvisioningConfig provisioningConfig) {
        ElementNode install = ProvisioningXmlWriter.addElement(null, ProvisioningXmlParser10.Element.INSTALLATION);
        if (provisioningConfig.hasFeaturePackDeps()) {
            for (FeaturePackConfig fp : provisioningConfig.getFeaturePackDeps()) {
                ElementNode fpElement = ProvisioningXmlWriter.addElement(install, ProvisioningXmlParser10.Element.FEATURE_PACK);
                ProvisioningXmlWriter.writeFeaturePackConfig(fpElement, fpElement.getNamespace(), fp, provisioningConfig.originOf(fp.getGav().toGa()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(install, ProvisioningXmlParser10.Element.INSTALLATION.getNamespace(), provisioningConfig);
        return install;
    }

    static void writeFeaturePackConfig(ElementNode fp, String ns, FeaturePackConfig featurePack, String origin) {
        ProvisioningXmlWriter.addGav(fp, featurePack.getGav());
        if (origin != null) {
            ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser10.Element.ORIGIN.getLocalName(), ns).addChild(new TextNode(origin));
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, ns, featurePack);
        ElementNode packages = null;
        if (!featurePack.isInheritPackages()) {
            packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser10.Element.PACKAGES.getLocalName(), ns);
            ProvisioningXmlWriter.addAttribute(packages, ProvisioningXmlParser10.Attribute.INHERIT, FALSE);
        }
        if (featurePack.hasExcludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser10.Element.PACKAGES.getLocalName(), ns);
            }
            for (String excluded : featurePack.getExcludedPackages()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement(packages, ProvisioningXmlParser10.Element.EXCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser10.Attribute.NAME, excluded);
            }
        }
        if (featurePack.hasIncludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement(fp, ProvisioningXmlParser10.Element.PACKAGES.getLocalName(), ns);
            }
            for (PackageConfig included : featurePack.getIncludedPackages()) {
                ElementNode include = ProvisioningXmlWriter.addElement(packages, ProvisioningXmlParser10.Element.INCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(include, ProvisioningXmlParser10.Attribute.NAME, included.getName());
            }
        }
    }

    static void writeConfigCustomizations(ElementNode parent, String ns, ConfigCustomizations configCustoms) {
        ElementNode defConfigsE = null;
        if (!configCustoms.isInheritConfigs()) {
            defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            ProvisioningXmlWriter.addAttribute(defConfigsE, ProvisioningXmlParser10.Attribute.INHERIT, FALSE);
        }
        if (!configCustoms.isInheritModelOnlyConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            ProvisioningXmlWriter.addAttribute(defConfigsE, ProvisioningXmlParser10.Attribute.INHERIT_UNNAMED_MODELS, FALSE);
        }
        if (configCustoms.hasFullModelsExcluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (Map.Entry<String, Boolean> entry : configCustoms.getFullModelsExcluded().entrySet()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser10.Element.EXCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser10.Attribute.MODEL, entry.getKey());
                if (entry.getValue().booleanValue()) continue;
                ProvisioningXmlWriter.addAttribute(exclude, ProvisioningXmlParser10.Attribute.NAMED_MODELS_ONLY, FALSE);
            }
        }
        if (configCustoms.hasFullModelsIncluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            Object[] array = configCustoms.getFullModelsIncluded().toArray(new String[configCustoms.getFullModelsIncluded().size()]);
            Arrays.sort(array);
            for (Object modelName : array) {
                ElementNode included = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser10.Element.INCLUDE.getLocalName(), ns);
                ProvisioningXmlWriter.addAttribute(included, ProvisioningXmlParser10.Attribute.MODEL, (String)modelName);
            }
        }
        if (configCustoms.hasExcludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (ConfigId configId : configCustoms.getExcludedConfigs()) {
                ElementNode excluded = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser10.Element.EXCLUDE.getLocalName(), ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute(excluded, ProvisioningXmlParser10.Attribute.MODEL, configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute(excluded, ProvisioningXmlParser10.Attribute.NAME, configId.getName());
            }
        }
        if (configCustoms.hasIncludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement(parent, ProvisioningXmlParser10.Element.DEFAULT_CONFIGS.getLocalName(), ns);
            }
            for (ConfigId configId : configCustoms.getIncludedConfigs()) {
                ElementNode includeElement = ProvisioningXmlWriter.addElement(defConfigsE, ProvisioningXmlParser10.Element.INCLUDE.getLocalName(), ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute(includeElement, ProvisioningXmlParser10.Attribute.MODEL, configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute(includeElement, ProvisioningXmlParser10.Attribute.NAME, configId.getName());
            }
        }
        if (configCustoms.hasDefinedConfigs()) {
            for (ConfigModel configModel : configCustoms.getDefinedConfigs()) {
                parent.addChild(ConfigXmlWriter.getInstance().toElement(configModel, ns));
            }
        }
    }

    static void addGav(ElementNode fp, ArtifactCoords.Gav fpGav) {
        ProvisioningXmlWriter.addAttribute(fp, ProvisioningXmlParser10.Attribute.GROUP_ID, fpGav.getGroupId());
        ProvisioningXmlWriter.addAttribute(fp, ProvisioningXmlParser10.Attribute.ARTIFACT_ID, fpGav.getArtifactId());
        if (fpGav.getVersion() != null) {
            ProvisioningXmlWriter.addAttribute(fp, ProvisioningXmlParser10.Attribute.VERSION, fpGav.getVersion());
        }
    }
}

