/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.util.StringUtils;

public interface Errors {
    public static String pathDoesNotExist(Path p) {
        return "Failed to locate " + p.toAbsolutePath();
    }

    public static String pathAlreadyExists(Path p) {
        return "Path already exists " + p.toAbsolutePath();
    }

    public static String mkdirs(Path p) {
        return "Failed to make directories " + p.toAbsolutePath();
    }

    public static String readDirectory(Path p) {
        return "Failed to read directory " + p.toAbsolutePath();
    }

    public static String notADir(Path p) {
        return p.toAbsolutePath() + " is not a directory";
    }

    public static String copyFile(Path src, Path target) {
        return "Failed to copy " + src + " to " + target;
    }

    public static String deletePath(Path src) {
        return "Failed to delete " + src;
    }

    public static String moveFile(Path src, Path target) {
        return "Failed to move " + src.toAbsolutePath() + " to " + target.toAbsolutePath();
    }

    public static String openFile(Path p) {
        return "Failed to open " + p.toAbsolutePath();
    }

    public static String readFile(Path p) {
        return "Failed to read " + p.toAbsolutePath();
    }

    public static String parseXml() {
        return "Failed to parse XML";
    }

    public static String parseXml(Path p) {
        return "Failed to parse " + p.toAbsolutePath();
    }

    public static String writeFile(Path p) {
        return "Failed to write to " + p.toAbsolutePath();
    }

    public static String hashCalculation(Path path) {
        return "Hash calculation failed for " + path;
    }

    public static String homeDirNotUsable(Path p) {
        return p + " has to be empty or contain a provisioned installation to be used by the tool";
    }

    public static String fpVersionCheckFailed(Collection<ArtifactCoords.Ga> missingVersions, Collection<Set<ArtifactCoords.Gav>> versionConflicts) throws ProvisioningException {
        StringWriter strWriter = new StringWriter();
        try (BufferedWriter writer = new BufferedWriter(strWriter);){
            writer.write("Feature-pack versions check failed with the following errors:");
            writer.newLine();
            if (!missingVersions.isEmpty()) {
                writer.write(" * ");
                writer.write(Errors.failedToResolveReleaseVersions(missingVersions));
                writer.write(59);
                writer.newLine();
            }
            if (!versionConflicts.isEmpty()) {
                for (Collection collection : versionConflicts) {
                    writer.write(" * ");
                    writer.write(Errors.featurePackVersionConflict(collection));
                    writer.write(59);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to report version check errors", e);
        }
        return strWriter.toString();
    }

    public static String failedToResolveReleaseVersions(Collection<ArtifactCoords.Ga> gas) {
        StringBuilder buf = new StringBuilder("Missing release version");
        if (gas.size() > 1) {
            buf.append('s');
        }
        buf.append(" of ");
        StringUtils.append(buf, gas);
        return buf.toString();
    }

    public static String packageContentCopyFailed(String packageName) {
        return "Failed to copy package " + packageName + " content";
    }

    public static String packageNotFound(ArtifactCoords.Gav fp, String packageName) {
        return "Failed to resolve package " + packageName + " in " + fp;
    }

    public static String unknownPackage(ArtifactCoords.Gav gav, String pkgName) {
        return "Package " + pkgName + " is not found in " + gav;
    }

    public static String unknownFeaturePack(ArtifactCoords.Gav gav) {
        return "Feature-pack " + gav + " is not found";
    }

    public static String unsatisfiedFeaturePackDep(ArtifactCoords.Gav gav) {
        return "Feature-pack " + gav + " is required dependency";
    }

    public static String unknownFeaturePackDependency(ArtifactCoords.Ga ga) {
        return ga + " is not found among the feature-pack dependencies";
    }

    public static String featurePackVersionConflict(ArtifactCoords.Gav gav, ArtifactCoords.Gav gav2) {
        LinkedHashSet<ArtifactCoords.Gav> gavs = new LinkedHashSet<ArtifactCoords.Gav>(2);
        gavs.add(gav);
        gavs.add(gav2);
        return Errors.featurePackVersionConflict(gavs);
    }

    public static String featurePackVersionConflict(Collection<ArtifactCoords.Gav> gavs) {
        Iterator<ArtifactCoords.Gav> i = gavs.iterator();
        ArtifactCoords.Gav gav = i.next();
        StringBuilder buf = new StringBuilder("Please pick the desired version of ").append(gav.toGa()).append(" explicitly in the provisioning config. Current configuration references the following versions ").append(gav.getVersion());
        while (i.hasNext()) {
            gav = i.next();
            buf.append(", ").append(gav.getVersion());
        }
        return buf.toString();
    }

    public static String unsatisfiedPackageDependencies(ArtifactCoords.Gav fpGav, String packageName, Collection<String> unsatisfiedDeps) {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature-pack ").append(fpGav).append(" package ").append(packageName).append(" has unsatisfied dependencies on packages: ");
        StringUtils.append(buf, unsatisfiedDeps);
        return buf.toString();
    }

    public static String unsatisfiedPackageDependency(ArtifactCoords.Gav fpGav, String targetPackage) {
        return "Unsatisfied dependency on feature-pack " + fpGav + " package " + targetPackage;
    }

    public static String unsatisfiedExternalPackageDependency(ArtifactCoords.Gav srcGav, String srcPackage, ArtifactCoords.Gav targetGav, String targetPackage) {
        return "Feature-pack " + srcGav + " package " + srcPackage + " has unsatisfied dependency on feature-pack " + targetGav + " package " + targetPackage;
    }

    public static String resolvePackage(ArtifactCoords.Gav fpGav, String packageName) {
        return "Failed to resolve feature-pack " + fpGav + " package " + packageName;
    }

    public static String packageExcludeInclude(String packageName) {
        return "Attempt to explicitly include and exclude package " + packageName;
    }

    public static String duplicateDependencyName(String name) {
        return "Dependency with name " + name + " already exists";
    }

    public static String unknownFeaturePackDependencyName(ArtifactCoords.Gav gav, String depName) {
        return "Dependency " + depName + " not found in " + gav + " feature-pack description";
    }

    public static String unknownFeaturePackDependencyName(String depName) {
        return depName + " was not found among the feature-pack dependencies";
    }

    public static String featurePackAlreadyInstalled(ArtifactCoords.Gav gav) {
        return "Feature-pack " + gav + " is already installed";
    }

    public static String unknownFeaturePackDependencyName(ArtifactCoords.Gav fpGav, String pkgName, String depName) {
        return fpGav + " package " + pkgName + " references unknown feature-pack dependency " + depName;
    }

    public static String packageAlreadyExists(ArtifactCoords.Gav gav, String name) {
        return "Package " + name + " already exists in feature-pack " + gav;
    }

    public static String noCapabilityProvider(String capability) {
        return "No provider found for capability '" + capability + "'";
    }

    public static String noCapabilityProvider(ResolvedFeature feature, CapabilitySpec capSpec, String resolvedCap) {
        StringBuilder buf = new StringBuilder();
        buf.append("No provider found for capability ").append(resolvedCap);
        buf.append(" required by ");
        if (feature.hasId()) {
            buf.append(feature.getId());
        } else {
            buf.append(" an instance of ").append(feature.getSpecId());
        }
        if (!capSpec.isStatic()) {
            buf.append(" as ").append(capSpec.toString());
        }
        return buf.toString();
    }

    public static String capabilityMissingParameter(CapabilitySpec cap, String param) {
        return "Parameter " + param + " is missing value to resolve capability " + cap;
    }

    public static String illegalCapabilityElement(CapabilitySpec cap, String resolvedPart, String elem) {
        return "Failed to resolve capability " + cap + " with illegal element value of '" + elem + "' at " + resolvedPart;
    }

    public static String failedToResolveCapability(ResolvedFeature feature, CapabilitySpec cap) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve capability ").append(cap).append(" for ");
        Errors.appendFeature(buf, feature);
        return buf.toString();
    }

    public static String failedToResolveParameter(ResolvedSpecId specId, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve ").append(specId).append(" parameter ").append(name);
        return buf.toString();
    }

    public static String failedToResolveParameter(ResolvedSpecId specId, String name, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve ").append(specId).append(" parameter ").append(name).append(" value ").append(value);
        return buf.toString();
    }

    public static String failedToResolveFeatureReference(FeatureReferenceSpec refSpec, ResolvedSpecId spec) {
        return "Failed to resolve feature reference " + refSpec.getName() + " for " + spec;
    }

    public static String failedToResolveConfigSpec(String model, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to resolve config");
        Errors.appendConfig(buf, model, name);
        return buf.toString();
    }

    public static String failedToBuildConfigSpec(String model, String name) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to build config");
        Errors.appendConfig(buf, model, name);
        return buf.toString();
    }

    public static String failedToInitializeForeignKeyParams(ResolvedSpecId specId, ResolvedFeatureId parentId, Map<String, ?> params) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to initialize the foreign key parameters for the feature ").append(specId).append(" with parameters ");
        StringUtils.append(buf, params.entrySet());
        buf.append(" referencing ID ").append(parentId);
        return buf.toString();
    }

    public static String idParamForeignKeyInitConflict(ResolvedSpecId specId, String param, Object prevValue, Object newValue) {
        return "Value '" + prevValue + "' of ID parameter " + param + " of " + specId + " conflicts with the corresponding parent ID value '" + newValue + "'";
    }

    public static String nonExistingForeignKeyTarget(String localParam, String refName, ResolvedSpecId specId, String targetParam, ResolvedSpecId targetSpecId) {
        return "Foreign key parameter " + localParam + " of " + specId + " reference " + refName + " is mapped to a non-existing ID parameter " + targetParam + " of " + targetSpecId;
    }

    public static String nonExistingForeignKeyParam(String refName, ResolvedSpecId specId, String targetParam) {
        return "Foreign key parameter " + targetParam + " of " + specId + " reference " + refName + " does not exist";
    }

    public static String featureRefNotInSpec(String featureRefName, String featureSpec) {
        return "Feature spec " + featureSpec + " does not include a feature reference named " + featureRefName;
    }

    public static String nonNillableRefIsNull(ResolvedFeature feature, String refName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Reference ").append(refName).append(" of ");
        Errors.appendFeature(buf, feature);
        return buf.append(" cannot be null").toString();
    }

    public static String unresolvedFeatureDep(ResolvedFeature feature, ResolvedFeatureId dep) {
        StringBuilder buf = new StringBuilder();
        Errors.appendFeature(buf, feature);
        buf.append(" has unresolved dependency on ").append(dep);
        return buf.toString();
    }

    public static String nonNillableParameterIsNull(ResolvedFeature feature, String paramName) {
        if (feature.hasId()) {
            return Errors.nonNillableParameterIsNull(feature.getId(), paramName);
        }
        return Errors.nonNillableParameterIsNull(feature.getSpecId(), paramName);
    }

    public static String nonNillableParameterIsNull(ResolvedSpecId specId, String paramName) {
        return "Non-nillable parameter " + paramName + " of " + specId + " has not been initialized";
    }

    public static String nonNillableParameterIsNull(ResolvedFeatureId featureId, String paramName) {
        return "Non-nillable parameter " + paramName + " of " + featureId + " has not been initialized";
    }

    public static String featureNotInScope(ResolvedFeatureId id, String groupName, ArtifactCoords.Gav fpGav) {
        StringBuilder buf = new StringBuilder();
        buf.append(id).append(" cannot be included into group ").append(groupName);
        if (fpGav != null) {
            buf.append(" from ").append(fpGav);
        }
        buf.append(" as it's not in the scope of the group");
        return buf.toString();
    }

    public static String unknownFeatureParameter(ResolvedSpecId specId, String paramName) {
        return "Feature spec " + specId + " does not contain parameter '" + paramName;
    }

    public static String featureIdParameterCantBeUnset(ResolvedFeatureId id, String paramName) {
        return "Parameter " + paramName + " of " + id + " cannot be unset";
    }

    public static String featureIdParameterCantBeReset(ResolvedFeatureId id, String paramName) {
        return "Parameter " + paramName + " of " + id + " cannot be reset";
    }

    public static String unknownFeatureParameter(String featureSpec, String paramName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Feature spec ").append(featureSpec).append(" does not define parameter ").append(paramName);
        return buf.toString();
    }

    public static String failedToProcess(ArtifactCoords.Gav fpGav, FeatureConfig feature) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to process feature-pack ").append(fpGav).append(" feature ").append(feature);
        return buf.toString();
    }

    public static String failedToProcess(ArtifactCoords.Gav fpGav, String groupName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to process feature-pack ").append(fpGav).append(" group ").append(groupName);
        return buf.toString();
    }

    public static void appendConfig(StringBuilder buf, String model, String name) {
        if (model != null) {
            buf.append(" model ").append(model);
        }
        if (name != null) {
            buf.append(" named ").append(name);
        }
    }

    public static void appendFeature(StringBuilder buf, ResolvedFeature feature) {
        if (feature.hasId()) {
            buf.append(feature.getId());
        } else {
            buf.append(feature.getSpecId()).append(" configuration");
        }
    }
}

