/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisioningManager {
    private final String encoding;
    private final Path installationHome;
    private final ArtifactRepositoryManager artifactResolver;
    private final MessageWriter messageWriter;
    private ProvisioningConfig provisioningConfig;

    public static Builder builder() {
        return new Builder();
    }

    private ProvisioningManager(Builder builder) {
        this.encoding = builder.encoding;
        this.installationHome = builder.installationHome;
        this.artifactResolver = builder.artifactResolver;
        this.messageWriter = builder.messageWriter == null ? DefaultMessageWriter.getDefaultInstance() : builder.messageWriter;
    }

    public Path getInstallationHome() {
        return this.installationHome;
    }

    public ProvisioningConfig getProvisioningConfig() throws ProvisioningException {
        if (this.provisioningConfig == null) {
            this.provisioningConfig = this.readProvisioningConfig(PathsUtils.getProvisioningXml(this.installationHome));
        }
        return this.provisioningConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProvisionedState getProvisionedState() throws ProvisioningException {
        Path xml = PathsUtils.getProvisionedStateXml(this.installationHome);
        if (!Files.exists(xml, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(xml);){
            ProvisionedState.Builder builder = ProvisionedState.builder();
            XmlParsers.parse(reader, builder);
            ProvisionedState provisionedState = builder.build();
            return provisionedState;
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(xml), e);
        }
    }

    public void install(ArtifactCoords.Gav fpGav) throws ProvisioningException {
        this.install(FeaturePackConfig.forGav(fpGav));
    }

    public void install(ArtifactCoords.Gav fpGav, Map<String, String> options) throws ProvisioningException {
        this.install(FeaturePackConfig.forGav(fpGav), options);
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.install(fpConfig, false);
    }

    public void install(FeaturePackConfig fpConfig, Map<String, String> options) throws ProvisioningException {
        this.install(fpConfig, false, options);
    }

    public void install(ArtifactCoords.Gav fpGav, boolean replaceInstalledVersion) throws ProvisioningException {
        this.install(FeaturePackConfig.forGav(fpGav), replaceInstalledVersion);
    }

    public void install(ArtifactCoords.Gav fpGav, boolean replaceInstalledVersion, Map<String, String> options) throws ProvisioningException {
        this.install(FeaturePackConfig.forGav(fpGav), replaceInstalledVersion, options);
    }

    public void install(FeaturePackConfig fpConfig, boolean replaceInstalledVersion) throws ProvisioningException {
        this.install(fpConfig, replaceInstalledVersion, Collections.emptyMap());
    }

    public void install(FeaturePackConfig fpConfig, boolean replaceInstalledVersion, Map<String, String> options) throws ProvisioningException {
        ProvisioningConfig provisionedConfig = this.getProvisioningConfig();
        if (provisionedConfig == null) {
            this.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(fpConfig)).build(), options);
            return;
        }
        ProvisionedFeaturePack installedFp = this.getProvisionedState().getFeaturePack(fpConfig.getGav().toGa());
        if (installedFp == null) {
            this.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder(provisionedConfig).addFeaturePackDep(fpConfig)).build(), options);
            return;
        }
        if (!replaceInstalledVersion) {
            if (installedFp.getGav().equals(fpConfig.getGav())) {
                throw new ProvisioningException(Errors.featurePackAlreadyInstalled(fpConfig.getGav()));
            }
            throw new ProvisioningException(Errors.featurePackVersionConflict(fpConfig.getGav(), installedFp.getGav()));
        }
        if (provisionedConfig.hasFeaturePackDep(fpConfig.getGav().toGa())) {
            FeaturePackConfig installedFpConfig = provisionedConfig.getFeaturePackDep(fpConfig.getGav().toGa());
            String origin = provisionedConfig.originOf(fpConfig.getGav().toGa());
            this.provision(((ProvisioningConfig.Builder)((ProvisioningConfig.Builder)ProvisioningConfig.builder(provisionedConfig).removeFeaturePackDep(installedFpConfig.getGav())).addFeaturePackDep(origin, fpConfig)).build(), options);
            return;
        }
        this.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder(provisionedConfig).addFeaturePackDep(fpConfig)).build(), options);
    }

    public void uninstall(ArtifactCoords.Gav gav) throws ProvisioningException {
        ProvisioningConfig provisionedConfig = this.getProvisioningConfig();
        if (provisionedConfig == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        if (!this.provisioningConfig.hasFeaturePackDep(gav.toGa())) {
            if (this.getProvisionedState().hasFeaturePack(gav.toGa())) {
                throw new ProvisioningException(Errors.unsatisfiedFeaturePackDep(gav));
            }
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        this.doProvision(provisionedConfig, gav.toGa(), Collections.emptyMap());
    }

    public void provision(ProvisioningConfig provisioningConfig) throws ProvisioningException {
        this.doProvision(provisioningConfig, null, Collections.emptyMap());
    }

    public void provision(ProvisioningConfig provisioningConfig, Map<String, String> options) throws ProvisioningException {
        this.doProvision(provisioningConfig, null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProvision(ProvisioningConfig provisioningConfig, ArtifactCoords.Ga uninstallGa, Map<String, String> options) throws ProvisioningException {
        ProvisioningManager.checkInstallationDir(this.installationHome);
        if (!provisioningConfig.hasFeaturePackDeps()) {
            this.emptyHomeDir();
            this.provisioningConfig = null;
            return;
        }
        if (this.artifactResolver == null) {
            throw new ProvisioningException("Artifact resolver has not been provided.");
        }
        try (ProvisioningRuntime runtime = this.getRuntime(provisioningConfig, uninstallGa, options);){
            if (runtime == null) {
                return;
            }
            ProvisioningRuntime.install(runtime);
        }
        finally {
            this.provisioningConfig = null;
        }
    }

    private void emptyHomeDir() throws ProvisioningException {
        if (Files.exists(this.installationHome, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.installationHome);){
                for (Path p : stream) {
                    IoUtils.recursiveDelete(p);
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readDirectory(this.installationHome));
            }
        }
    }

    public ProvisioningRuntime getRuntime(ProvisioningConfig provisioningConfig, ArtifactCoords.Ga uninstallGa, Map<String, String> options) throws ProvisioningException {
        ProvisioningRuntimeBuilder builder = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).setArtifactResolver(this.artifactResolver).setConfig(provisioningConfig).setEncoding(this.encoding).setInstallDir(this.installationHome).addOptions(options);
        if (uninstallGa != null) {
            builder.uninstall(uninstallGa);
        }
        return builder.build();
    }

    public static void checkInstallationDir(Path installationHome) throws ProvisioningException {
        if (Files.exists(installationHome, new LinkOption[0])) {
            if (!Files.isDirectory(installationHome, new LinkOption[0])) {
                throw new ProvisioningException(Errors.notADir(installationHome));
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(installationHome);){
                boolean usableDir = true;
                Iterator<Path> i = stream.iterator();
                while (i.hasNext()) {
                    if (i.next().getFileName().toString().equals(".galleon")) {
                        usableDir = true;
                        break;
                    }
                    usableDir = false;
                }
                if (!usableDir) {
                    throw new ProvisioningException(Errors.homeDirNotUsable(installationHome));
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readDirectory(installationHome));
            }
        }
    }

    public void provision(Path provisioningXml) throws ProvisioningException {
        this.provision(this.readProvisioningConfig(provisioningXml));
    }

    public void exportProvisioningConfig(Path location) throws ProvisioningException, IOException {
        Path exportPath = location;
        Path userProvisionedXml = PathsUtils.getProvisioningXml(this.installationHome);
        if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
            throw new ProvisioningException("Provisioned state record is missing for " + this.installationHome);
        }
        if (Files.isDirectory(exportPath, new LinkOption[0])) {
            exportPath = exportPath.resolve(userProvisionedXml.getFileName());
        }
        IoUtils.copy(userProvisionedXml, exportPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportConfigurationChanges(Path location, ArtifactCoords.Gav diffGav, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        if (configuration == null) {
            Path userProvisionedXml = PathsUtils.getProvisioningXml(this.installationHome);
            if (!Files.exists(userProvisionedXml, new LinkOption[0])) {
                throw new ProvisioningException("Provisioned state record is missing for " + this.installationHome);
            }
            Path xmlTarget = location;
            if (Files.isDirectory(xmlTarget, new LinkOption[0])) {
                xmlTarget = xmlTarget.resolve(userProvisionedXml.getFileName());
            }
            Files.copy(userProvisionedXml, xmlTarget, StandardCopyOption.REPLACE_EXISTING);
        }
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        try {
            ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setArtifactResolver(this.artifactResolver).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

                @Override
                public void verbose(Throwable cause, CharSequence message) {
                }

                @Override
                public void print(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.print(cause, message);
                }

                @Override
                public void error(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.error(cause, message);
                }

                @Override
                public boolean isVerboseEnabled() {
                    return false;
                }

                @Override
                public void close() throws Exception {
                }
            }));
            reference.provision(configuration);
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).setArtifactResolver(this.artifactResolver).setConfig(configuration).setEncoding(this.encoding).setInstallDir(tempInstallationDir).addOptions(options).setOperation(diffGav != null ? "diff-to-feature-pack" : "diff").build();){
                if (diffGav != null) {
                    ProvisioningRuntime.exportToFeaturePack(runtime, diffGav, location, this.installationHome);
                } else {
                    ProvisioningRuntime.diff(runtime, location, this.installationHome);
                    runtime.getDiff().toXML(location, this.installationHome);
                }
            }
            catch (IOException | XMLStreamException e) {
                this.messageWriter.error(e, e.getMessage());
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(ArtifactCoords.Gav fpGav, Map<String, String> options) throws ProvisioningException, IOException {
        ProvisioningConfig configuration = this.getProvisioningConfig();
        Path tempInstallationDir = IoUtils.createRandomTmpDir();
        Path stagedDir = IoUtils.createRandomTmpDir();
        try {
            ProvisioningManager reference = new ProvisioningManager(ProvisioningManager.builder().setArtifactResolver(this.artifactResolver).setEncoding(this.encoding).setInstallationHome(tempInstallationDir).setMessageWriter(new MessageWriter(){

                @Override
                public void verbose(Throwable cause, CharSequence message) {
                }

                @Override
                public void print(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.print(cause, message);
                }

                @Override
                public void error(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.error(cause, message);
                }

                @Override
                public boolean isVerboseEnabled() {
                    return false;
                }

                @Override
                public void close() throws Exception {
                }
            }));
            reference.provision(configuration);
            Files.createDirectories(stagedDir, new FileAttribute[0]);
            reference = new ProvisioningManager(ProvisioningManager.builder().setArtifactResolver(this.artifactResolver).setEncoding(this.encoding).setInstallationHome(stagedDir).setMessageWriter(new MessageWriter(){

                @Override
                public void verbose(Throwable cause, CharSequence message) {
                }

                @Override
                public void print(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.print(cause, message);
                }

                @Override
                public void error(Throwable cause, CharSequence message) {
                    ProvisioningManager.this.messageWriter.error(cause, message);
                }

                @Override
                public boolean isVerboseEnabled() {
                    return false;
                }

                @Override
                public void close() throws Exception {
                }
            }));
            reference.provision(((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.forGav(fpGav))).build());
            try (ProvisioningRuntime runtime = ProvisioningRuntimeBuilder.newInstance(this.messageWriter).setArtifactResolver(this.artifactResolver).setConfig(configuration).setEncoding(this.encoding).setInstallDir(tempInstallationDir).addOptions(options).setOperation("upgrade").build();){
                Files.createDirectories(tempInstallationDir.resolve("model_diff"), new FileAttribute[0]);
                ProvisioningRuntime.diff(runtime, tempInstallationDir.resolve("model_diff"), this.installationHome);
                runtime.setInstallDir(stagedDir);
                ProvisioningRuntime.upgrade(runtime, this.installationHome);
            }
        }
        finally {
            IoUtils.recursiveDelete(tempInstallationDir);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProvisioningConfig readProvisioningConfig(Path path) throws ProvisioningException {
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
            XmlParsers.parse(reader, builder);
            ProvisioningConfig provisioningConfig = builder.build();
            return provisioningConfig;
        }
        catch (IOException | XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml(path), e);
        }
    }

    public static class Builder {
        private String encoding = "UTF-8";
        private Path installationHome;
        private ArtifactRepositoryManager artifactResolver;
        private MessageWriter messageWriter;

        private Builder() {
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setInstallationHome(Path installationHome) {
            this.installationHome = installationHome;
            return this;
        }

        public Builder setArtifactResolver(ArtifactRepositoryManager artifactResolver) {
            this.artifactResolver = artifactResolver;
            return this;
        }

        public Builder setMessageWriter(MessageWriter messageWriter) {
            this.messageWriter = messageWriter;
            return this;
        }

        public ProvisioningManager build() {
            return new ProvisioningManager(this);
        }
    }
}

