/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.utils.Config;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.Configuration;
import org.jboss.galleon.cli.MavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.Universe;
import org.jboss.galleon.cli.Universes;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;

public class PmSession
implements CommandInvocationProvider<PmCommandInvocation>,
CompleterInvocationProvider<PmCompleterInvocation>,
CommandActivatorProvider,
OptionActivatorProvider<OptionActivator> {
    private PrintStream out;
    private PrintStream err;
    private final Configuration config;
    private final Universes universes;
    private State state;
    private FeatureContainer exploredContainer;
    private String currentPath;

    public PmSession(Configuration config) throws Exception {
        this.config = config;
        this.universes = Universes.buildUniverses(MavenArtifactRepositoryManager.getInstance(), config.getUniversesLocations());
    }

    public void setState(State session) {
        this.state = session;
    }

    public State getState() {
        return this.state;
    }

    public void setExploredContainer(FeatureContainer exploredContainer) {
        this.exploredContainer = exploredContainer;
    }

    public FeatureContainer getExploredContainer() {
        return this.exploredContainer;
    }

    public FeatureContainer getContainer() {
        if (this.state != null) {
            return this.state.getContainer();
        }
        if (this.exploredContainer != null) {
            return this.exploredContainer;
        }
        return null;
    }

    public String getCurrentPath() {
        if (this.state != null) {
            return this.state.getPath();
        }
        if (this.currentPath != null) {
            return this.currentPath;
        }
        return null;
    }

    public void setCurrentPath(String currentPath) {
        if (this.state != null) {
            this.state.setPath(currentPath);
        }
        if (currentPath != null) {
            this.currentPath = currentPath;
        }
    }

    public void println(String txt) {
        this.out.print(txt + Config.getLineSeparator());
    }

    public Configuration getPmConfiguration() {
        return this.config;
    }

    public Universes getUniverses() {
        return this.universes;
    }

    public ArtifactRepositoryManager getArtifactResolver() {
        return MavenArtifactRepositoryManager.getInstance();
    }

    public boolean hasPopulatedUniverse() {
        for (Universe u : this.universes.getUniverses()) {
            if (u.getStreamLocations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Prompt buildPrompt(AeshContext aeshCtx) {
        return PmSession.buildPrompt(aeshCtx.getCurrentWorkingDirectory().getName());
    }

    public static Prompt buildPrompt(String name) {
        return new Prompt('[' + name + "]$ ");
    }

    public static Path getWorkDir(AeshContext aeshCtx) {
        return Paths.get(aeshCtx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
    }

    @Override
    public PmCommandInvocation enhanceCommandInvocation(CommandInvocation commandInvocation) {
        return new PmCommandInvocation(this, this.out, this.err, commandInvocation);
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    void setErr(PrintStream err) {
        this.err = err;
    }

    @Override
    public PmCompleterInvocation enhanceCompleterInvocation(CompleterInvocation completerInvocation) {
        return new PmCompleterInvocation(completerInvocation, this);
    }

    public CommandActivator enhanceCommandActivator(CommandActivator ca) {
        if (ca instanceof PmCommandActivator) {
            ((PmCommandActivator)ca).setPmSession(this);
        }
        return ca;
    }

    @Override
    public OptionActivator enhanceOptionActivator(OptionActivator oa) {
        if (oa instanceof PmOptionActivator) {
            ((PmOptionActivator)oa).setPmSession(this);
        }
        return oa;
    }
}

