/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.InstalledStreamCompleter;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

@CommandDefinition(name="uninstall", description="Uninstalls specified feature-pack", activator=NoStateCommandActivator.class)
public class UninstallCommand
extends ProvisioningCommand {
    @Argument(completer=InstalledStreamCompleter.class)
    protected String streamName;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        ProvisioningManager manager = this.getManager(session);
        try {
            manager.uninstall(this.getGav(session.getPmSession()));
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException("Provisioning failed", e);
        }
    }

    private ArtifactCoords.Gav getGav(PmSession session) throws CommandExecutionException {
        if (this.streamName == null) {
            throw new CommandExecutionException("No feature-pack provided");
        }
        return ArtifactCoords.newGav(this.streamName);
    }
}

