/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.cli.UniverseLocation;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;

public class Universe {
    public static final String NS = "urn:jboss:universe:1.0";
    private static final String UNIVERSE = "universe";
    private static final String UNIVERSE_FILE = "universe.xml";
    private static final String STREAM = "stream";
    private static final String GROUP_ID = "group-id";
    private static final String ARTIFACT_ID = "artifact-id";
    private static final String VERSION_RANGE = "version-range";
    private static final String NAME = "name";
    private final Map<String, StreamLocation> streamLocations = new HashMap<String, StreamLocation>();
    private final UniverseLocation location;
    private final ArtifactRepositoryManager manager;

    private Universe(UniverseLocation location, ArtifactRepositoryManager manager) {
        this.location = location;
        this.manager = manager;
    }

    private void addStreamLocation(StreamLocation location) {
        this.streamLocations.put(location.getName(), location);
    }

    public UniverseLocation getLocation() {
        return this.location;
    }

    public Collection<StreamLocation> getStreamLocations() {
        return Collections.unmodifiableCollection(this.streamLocations.values());
    }

    public ArtifactCoords resolveStream(String name) throws ArtifactException {
        StreamLocation loc = this.streamLocations.get(name);
        if (loc == null) {
            throw new ArtifactException("Unknown stream " + name);
        }
        if (!loc.resolved()) {
            loc.resolve(this.manager);
        }
        return loc.getCoordinates();
    }

    static Universe buildUniverse(ArtifactRepositoryManager manager, UniverseLocation location) throws Exception {
        String latestVersion;
        String version = location.getCoordinates().getVersion();
        if ((version == null || version.isEmpty()) && (latestVersion = manager.getHighestVersion(location.getCoordinates(), location.getVersionRange())) != null) {
            location.updateLatestVersion(latestVersion);
        }
        Universe universe = new Universe(location, manager);
        Path p = manager.resolve(location.getCoordinates());
        try (JarFile jarFile = new JarFile(p.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().equals(UNIVERSE_FILE)) continue;
                InputStream input = jarFile.getInputStream(entry);
                Universe universe2 = Universe.parse(input, universe);
                return universe2;
            }
        }
        throw new Exception("Universe content not found");
    }

    private static Universe parse(InputStream input, Universe universe) throws Exception {
        XMLMapper mapper = XMLMapper.Factory.create();
        UniverseReader reader = new UniverseReader();
        mapper.registerRootElement(new QName(NS, UNIVERSE), reader);
        XMLStreamReader universeReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
        mapper.parseDocument(universe, universeReader);
        universeReader.close();
        return universe;
    }

    static class UniverseReader
    implements XMLElementReader<Universe> {
        UniverseReader() {
        }

        @Override
        public void readElement(XMLExtendedStreamReader reader, Universe universe) throws XMLStreamException {
            String localName = reader.getLocalName();
            if (!Universe.UNIVERSE.equals(localName)) {
                throw new XMLStreamException("Unexpected element: " + localName);
            }
            this.readUniverseElement_1_0(reader, universe);
        }

        public void readUniverseElement_1_0(XMLExtendedStreamReader reader, Universe universe) throws XMLStreamException {
            boolean universeEnded = false;
            while (reader.hasNext() && !universeEnded) {
                String localName;
                int tag = reader.nextTag();
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(Universe.STREAM)) {
                        String groupId = reader.getAttributeValue(null, Universe.GROUP_ID);
                        String artifactId = reader.getAttributeValue(null, Universe.ARTIFACT_ID);
                        String versionRange = reader.getAttributeValue(null, Universe.VERSION_RANGE);
                        String name = reader.getAttributeValue(null, Universe.NAME);
                        universe.addStreamLocation(new StreamLocation(name, ArtifactCoords.newInstance(groupId, artifactId, null, null), versionRange));
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(Universe.UNIVERSE)) continue;
                universeEnded = true;
            }
        }
    }

    public static class StreamLocation {
        private final String name;
        private ArtifactCoords coordinates;
        private final String versionRange;
        private boolean resolved;

        private StreamLocation(String name, ArtifactCoords coordinates, String versionRange) {
            this.name = name;
            this.coordinates = coordinates;
            this.versionRange = versionRange;
        }

        public String getName() {
            return this.name;
        }

        public ArtifactCoords getCoordinates() {
            return this.coordinates;
        }

        public String getVersionRange() {
            return this.versionRange;
        }

        private void resolve(ArtifactRepositoryManager manager) throws ArtifactException {
            if (!this.resolved) {
                String latestVersion = manager.getHighestVersion(this.coordinates, this.versionRange);
                if (latestVersion != null) {
                    this.coordinates = new ArtifactCoords(this.coordinates.getGroupId(), this.coordinates.getArtifactId(), latestVersion, this.coordinates.getClassifier(), this.coordinates.getExtension());
                }
                this.resolved = true;
            }
        }

        private boolean resolved() {
            return this.resolved;
        }
    }
}

