/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.model.FeatureContainer;

@CommandDefinition(name="explore", description="Explore a feature-pack or an installation", activator=NoStateCommandActivator.class)
public class StateExploreCommand
extends AbstractFeaturePackCommand {
    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        PmSession pm = session.getPmSession();
        String prompt = null;
        try {
            if (pm.getContainer() != null) {
                throw new CommandExecutionException("Already entered, use leave command");
            }
            FeatureContainer container = this.getFeatureContainer(pm, session.getAeshContext());
            pm.setExploredContainer(container);
            prompt = this.getName() + '/';
            pm.setCurrentPath("/");
        }
        catch (Exception ex) {
            if (ex instanceof CommandExecutionException) {
                throw (CommandExecutionException)ex;
            }
            throw new CommandExecutionException("Stream resolution failed", ex);
        }
        session.setPrompt(PmSession.buildPrompt(prompt));
        session.println("Exploring " + this.getName() + ". Use 'state leave' to leave exploration.");
    }
}

