/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.runtime.ResolvedFeatureId;

public class FeatureGroupsBuilder {
    private final Map<String, Group> allgroups = new HashMap<String, Group>();
    private final Group root = Group.fromString("", "###ROOT");
    private String currentPath;

    FeatureGroupsBuilder() {
        this.allgroups.put(this.root.getIdentity().getName(), this.root);
    }

    Group getRoot() {
        return this.root;
    }

    private Group addGroup(String value, Group current, List<String> pathItems, String grpName) {
        if (value != null) {
            current = this.addGroup(current, pathItems, grpName);
            current = this.addGroup(current, pathItems, value);
        }
        return current;
    }

    private Group addGroup(Group current, List<String> pathItems, String grpName) {
        Group fg = this.allgroups.get(this.currentPath + grpName);
        if (fg == null) {
            fg = Group.fromString("", grpName);
            this.allgroups.put(this.currentPath + grpName, fg);
        }
        current.addGroup(fg);
        this.currentPath = this.currentPath + fg.getIdentity().getName() + "/";
        pathItems.add(fg.getIdentity().getName());
        return fg;
    }

    Group buildFeatureGroups(String name, ResolvedFeatureId id, List<String> pathItems) {
        String[] groups = name.split("\\.");
        Group current = this.allgroups.get("###ROOT");
        this.currentPath = "/";
        for (int it = 0; it < groups.length; ++it) {
            String g = groups[it];
            String[] subs = g.split("_");
            if (subs.length > 1) {
                for (int i = 0; i < subs.length; ++i) {
                    String value = (String)id.getParams().get(subs[i]);
                    current = value != null ? this.addGroup(value, current, pathItems, subs[i]) : this.addGroup(current, pathItems, subs[i]);
                }
                continue;
            }
            String value = (String)id.getParams().get(g);
            if (value == null) continue;
            current = this.addGroup(value, current, pathItems, g);
        }
        return current;
    }

    Group buildFeatureSpecGroups(String name, FeatureSpecInfo info, boolean wildflyModel, List<String> pathItems) {
        String[] groups = name.split("\\.");
        Group current = this.allgroups.get("###ROOT");
        this.currentPath = "/";
        Set<String> params = info.getAllParameters();
        for (int it = 0; it < groups.length; ++it) {
            String g = groups[it];
            String[] subs = g.split("_");
            if (subs.length > 1) {
                for (int i = 0; i < subs.length; ++i) {
                    current = this.addGroup(current, pathItems, subs[i]);
                }
                continue;
            }
            current = this.addGroup(current, pathItems, g);
        }
        return current;
    }
}

