/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureSpec;

public class FeatureSpecInfo {
    private final ResolvedSpecId specId;
    private final ArtifactCoords.Gav currentFP;
    private final FeatureSpec spec;
    private final List<PackageInfo> packages = new ArrayList<PackageInfo>();
    private final List<PackageInfo> modules = new ArrayList<PackageInfo>();
    private boolean enabled;
    private Set<Identity> missingPackages;
    private String name;

    public FeatureSpecInfo(ResolvedSpecId specId, ArtifactCoords.Gav currentFP, FeatureSpec spec) {
        this.specId = specId;
        this.currentFP = currentFP;
        this.spec = spec;
    }

    void setName(String name) {
        this.name = name;
    }

    Set<String> getAllParameters() {
        return this.spec.getParams().keySet();
    }

    void addPackage(PackageInfo pkg) {
        if (pkg.hasContent()) {
            this.packages.add(pkg);
        } else if (pkg.isModule()) {
            this.modules.add(pkg);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<PackageInfo> getPackages() {
        return this.packages;
    }

    public String getType() {
        return this.spec.getName();
    }

    public List<PackageInfo> getModules() {
        return this.modules;
    }

    public FeatureSpec getSpec() {
        return this.spec;
    }

    public String getDescription() {
        return "no description available";
    }

    public ResolvedSpecId getSpecId() {
        return this.specId;
    }

    public String getFeatureSpecOrigin() {
        return Identity.buildOrigin(this.specId.getGav());
    }

    public boolean equals(Object other) {
        if (!(other instanceof FeatureSpecInfo)) {
            return false;
        }
        FeatureSpecInfo ofs = (FeatureSpecInfo)other;
        return this.specId.equals(ofs.specId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.specId);
        return hash;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean featureEnabled) {
        this.enabled = featureEnabled;
    }

    void setMissingPackages(Set<Identity> missingPackages) {
        this.missingPackages = missingPackages;
    }

    public Set<Identity> getMissingPackages() {
        return this.missingPackages;
    }
}

