/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.spec.PackageSpec;

public class PackageInfo {
    private static String MODULE_PATH = "pm/wildfly/module";
    private static String MODULE_XML = "module.xml";
    private final Path contentDir;
    private final PackageSpec spec;
    private final List<String> artifacts = new ArrayList<String>();
    private String moduleVersion;
    private boolean isModule;
    private boolean hasContent;
    List<String> content = new ArrayList<String>();
    private final Identity identity;
    private Set<Identity> providers = new HashSet<Identity>();
    private final ArtifactCoords.Gav gav;

    PackageInfo(ArtifactCoords.Gav gav, Identity identity, Path contentDir, PackageSpec spec, Map<String, String> variables) throws IOException, ProvisioningException {
        this.gav = gav;
        this.identity = identity;
        this.contentDir = contentDir;
        this.spec = spec;
        Path modulePath = contentDir.getParent().resolve(MODULE_PATH);
        this.isModule = Files.exists(modulePath, new LinkOption[0]);
        this.hasContent = Files.exists(contentDir, new LinkOption[0]);
        if (this.isModule()) {
            try {
                this.parseModuleDescriptor(variables);
            }
            catch (ParsingException ex) {
                throw new ProvisioningException(ex);
            }
        } else if (this.hasContent()) {
            this.fillContent();
        }
    }

    public ArtifactCoords.Gav getGav() {
        return this.gav;
    }

    private void fillContent() throws IOException {
        Files.walkFileTree(this.contentDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                String r = PackageInfo.this.contentDir.toString();
                String child = file.toString().substring(0, file.toString().length());
                String name = child.substring(r.length() + 1);
                PackageInfo.this.content.add(name);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        Collections.sort(this.content);
    }

    private void parseModuleDescriptor(Map<String, String> variables) throws IOException, ProvisioningException, ParsingException {
        Element resourcesElement;
        String exprBody;
        int optionsIndex;
        String artifactName;
        String vers;
        String versionExpr;
        Document document;
        Path modulePath = this.contentDir.getParent().resolve(MODULE_PATH);
        final ArrayList moduleHolder = new ArrayList();
        Files.walkFileTree(modulePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
                if (file.getFileName().toString().equals(MODULE_XML)) {
                    moduleHolder.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        if (moduleHolder.isEmpty()) {
            throw new ProvisioningException("No module descriptor for " + this.getIdentity());
        }
        Path p = (Path)moduleHolder.get(0);
        Builder builder = new Builder(false);
        try (BufferedReader reader = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
            document = builder.build(reader);
        }
        Element rootElement = document.getRootElement();
        Attribute versionAttribute = rootElement.getAttribute("version");
        if (versionAttribute != null && (versionExpr = versionAttribute.getValue()).startsWith("${") && versionExpr.endsWith("}") && (vers = variables.get(artifactName = (optionsIndex = (exprBody = versionExpr.substring(2, versionExpr.length() - 1)).indexOf(63)) > 0 ? exprBody.substring(0, optionsIndex) : exprBody)) != null) {
            int i = vers.lastIndexOf(":");
            if (i > 0) {
                vers = vers.substring(i + 1);
            }
            this.moduleVersion = vers;
        }
        if ((resourcesElement = rootElement.getFirstChildElement("resources", rootElement.getNamespaceURI())) != null) {
            Elements artfs = resourcesElement.getChildElements("artifact", rootElement.getNamespaceURI());
            int artifactCount = artfs.size();
            for (int i = 0; i < artifactCount; ++i) {
                Element element = artfs.get(i);
                assert (element.getLocalName().equals("artifact"));
                Attribute attribute = element.getAttribute("name");
                String nameExpr = attribute.getValue();
                if (!nameExpr.startsWith("${") || !nameExpr.endsWith("}")) continue;
                String exprBody2 = nameExpr.substring(2, nameExpr.length() - 1);
                int optionsIndex2 = exprBody2.indexOf(63);
                String artifactName2 = optionsIndex2 >= 0 ? exprBody2.substring(0, optionsIndex2) : exprBody2;
                String resolved = variables.get(artifactName2);
                this.artifacts.add(resolved);
            }
        }
    }

    public List<String> getContent() {
        return this.content;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public final boolean isModule() {
        return this.isModule;
    }

    public List<String> getArtifacts() {
        return this.artifacts;
    }

    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public final boolean hasContent() {
        return this.hasContent;
    }

    public PackageSpec getSpec() {
        return this.spec;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageInfo)) {
            return false;
        }
        PackageInfo pi = (PackageInfo)obj;
        return pi.getIdentity().equals(this.getIdentity());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.identity);
        return hash;
    }

    void addProvider(Identity provider) {
        this.providers.add(provider);
    }

    public Set<Identity> getProviders() {
        return this.providers;
    }
}

