/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigCustomizationsBuilder;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.util.CollectionUtils;

public abstract class FeaturePackDepsConfigBuilder<B extends FeaturePackDepsConfigBuilder<B>>
extends ConfigCustomizationsBuilder<B> {
    Map<ArtifactCoords.Ga, FeaturePackConfig> fpDeps = Collections.emptyMap();
    Map<String, FeaturePackConfig> fpDepsByOrigin = Collections.emptyMap();
    Map<ArtifactCoords.Ga, String> fpGaToOrigin = Collections.emptyMap();

    public B addFeaturePackDep(FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        return this.addFeaturePackDep(null, dependency);
    }

    public B addFeaturePackDep(String origin, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        if (this.fpDeps.containsKey(dependency.getGav().toGa())) {
            throw new ProvisioningDescriptionException("Feature-pack already added " + dependency.getGav().toGa());
        }
        if (origin != null) {
            if (this.fpDepsByOrigin.containsKey(origin)) {
                throw new ProvisioningDescriptionException(Errors.duplicateDependencyName(origin));
            }
            this.fpDepsByOrigin = CollectionUtils.put(this.fpDepsByOrigin, origin, dependency);
            this.fpGaToOrigin = CollectionUtils.put(this.fpGaToOrigin, dependency.getGav().toGa(), origin);
        }
        this.fpDeps = CollectionUtils.putLinked(this.fpDeps, dependency.getGav().toGa(), dependency);
        return (B)this;
    }

    public B removeFeaturePackDep(ArtifactCoords.Gav gav) throws ProvisioningException {
        String origin;
        ArtifactCoords.Ga ga = gav.toGa();
        FeaturePackConfig fpDep = this.fpDeps.get(ga);
        if (fpDep == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        if (!fpDep.getGav().equals(gav)) {
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        if (this.fpDeps.size() == 1) {
            this.fpDeps = Collections.emptyMap();
            this.fpDepsByOrigin = Collections.emptyMap();
            this.fpGaToOrigin = Collections.emptyMap();
            return (B)this;
        }
        this.fpDeps = CollectionUtils.remove(this.fpDeps, ga);
        if (!this.fpGaToOrigin.isEmpty() && (origin = this.fpGaToOrigin.get(ga)) != null) {
            if (this.fpDepsByOrigin.size() == 1) {
                this.fpDepsByOrigin = Collections.emptyMap();
                this.fpGaToOrigin = Collections.emptyMap();
            } else {
                this.fpDepsByOrigin.remove(origin);
                this.fpGaToOrigin.remove(ga);
            }
        }
        return (B)this;
    }

    public int getFeaturePackDepIndex(ArtifactCoords.Gav gav) throws ProvisioningException {
        ArtifactCoords.Ga ga = gav.toGa();
        FeaturePackConfig fpDep = this.fpDeps.get(ga);
        if (fpDep == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        if (!fpDep.getGav().equals(gav)) {
            throw new ProvisioningException(Errors.unknownFeaturePack(gav));
        }
        int i = 0;
        for (ArtifactCoords.Ga g : this.fpDeps.keySet()) {
            if (g.equals(ga)) break;
            ++i;
        }
        return i;
    }

    public B addFeaturePackDep(int index, FeaturePackConfig dependency) throws ProvisioningDescriptionException {
        if (index >= this.fpDeps.size()) {
            this.addFeaturePackDep(dependency);
        } else {
            if (this.fpDeps.containsKey(dependency.getGav().toGa())) {
                throw new ProvisioningDescriptionException("Feature-pack already added " + dependency.getGav().toGa());
            }
            Map<Object, Object> tmp = Collections.emptyMap();
            int i = 0;
            for (Map.Entry<ArtifactCoords.Ga, FeaturePackConfig> entry : this.fpDeps.entrySet()) {
                if (i == index) {
                    tmp = CollectionUtils.putLinked(tmp, dependency.getGav().toGa(), dependency);
                }
                tmp = CollectionUtils.putLinked(tmp, entry.getKey(), entry.getValue());
                ++i;
            }
            this.fpDeps = tmp;
        }
        return (B)this;
    }
}

