/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.CollectionUtils;

public class ProvisioningLayout {
    private final Map<ArtifactCoords.Ga, FeaturePackLayout> featurePacks;

    public static Builder builder() {
        return new Builder();
    }

    private ProvisioningLayout(Builder builder) {
        this.featurePacks = CollectionUtils.unmodifiable(builder.featurePacks);
    }

    public boolean hasFeaturePacks() {
        return !this.featurePacks.isEmpty();
    }

    public boolean contains(ArtifactCoords.Gav fpGav) {
        return this.featurePacks.containsKey(fpGav.toGa());
    }

    public FeaturePackLayout getFeaturePack(ArtifactCoords.Gav fpGav) {
        return this.featurePacks.get(fpGav.toGa());
    }

    public Collection<FeaturePackLayout> getFeaturePacks() {
        return this.featurePacks.values();
    }

    public static class Builder {
        private Map<ArtifactCoords.Ga, FeaturePackLayout> featurePacks = Collections.emptyMap();

        private Builder() {
        }

        public Builder addFeaturePack(FeaturePackLayout fp) throws ProvisioningDescriptionException {
            assert (fp != null) : "fp is null";
            ArtifactCoords.Ga fpGa = fp.getGav().toGa();
            if (this.featurePacks.containsKey(fpGa)) {
                ArtifactCoords.Gav existingGav = this.featurePacks.get(fpGa).getGav();
                if (existingGav.getVersion().equals(fp.getGav().getVersion())) {
                    return this;
                }
                throw new ProvisioningDescriptionException(Errors.featurePackVersionConflict(fp.getGav(), existingGav));
            }
            this.featurePacks = CollectionUtils.put(this.featurePacks, fpGa, fp);
            return this;
        }

        public ProvisioningLayout build() throws ProvisioningDescriptionException {
            for (FeaturePackLayout fp : this.featurePacks.values()) {
                if (!fp.externalPkgDeps) continue;
                FeaturePackSpec fpSpec = fp.getSpec();
                for (PackageSpec pkg : fp.getPackages()) {
                    if (!pkg.hasExternalPackageDeps()) continue;
                    for (String origin : pkg.getPackageOrigins()) {
                        FeaturePackConfig fpDepConfig;
                        try {
                            fpDepConfig = fpSpec.getFeaturePackDep(origin);
                        }
                        catch (ProvisioningDescriptionException e) {
                            throw new ProvisioningDescriptionException(Errors.unknownFeaturePackDependencyName(fpSpec.getGav(), pkg.getName(), origin), e);
                        }
                        FeaturePackLayout fpDepLayout = this.featurePacks.get(fpDepConfig.getGav().toGa());
                        if (fpDepLayout == null) {
                            throw new ProvisioningDescriptionException(Errors.unknownFeaturePack(fpDepConfig.getGav()));
                        }
                        for (PackageDependencySpec pkgDep : pkg.getExternalPackageDeps(origin)) {
                            String pkgDepName = pkgDep.getName();
                            if (!fpDepLayout.hasPackage(pkgDepName)) {
                                throw new ProvisioningDescriptionException(Errors.unsatisfiedExternalPackageDependency(fpSpec.getGav(), pkg.getName(), fpDepConfig.getGav(), pkgDep.getName()));
                            }
                            if (!fpDepConfig.isPackageExcluded(pkgDepName) || pkgDep.isOptional()) continue;
                            throw new ProvisioningDescriptionException(Errors.unsatisfiedExternalPackageDependency(fpSpec.getGav(), pkg.getName(), fpDepConfig.getGav(), pkgDep.getName()));
                        }
                    }
                }
            }
            return new ProvisioningLayout(this);
        }
    }
}

