/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.galleon.ArtifactCoords;

public class ArtifactItem
implements DependableCoordinate,
ArtifactCoordinate {
    private String groupId;
    private String artifactId;
    private String version = null;
    private String type = "jar";
    private String classifier;
    private String extension;
    private Artifact artifact;

    public ArtifactItem() {
    }

    public ArtifactItem(Artifact artifact) {
        this.setArtifact(artifact);
        this.setArtifactId(artifact.getArtifactId());
        this.setClassifier(artifact.getClassifier());
        this.setGroupId(artifact.getGroupId());
        this.setType(artifact.getType());
        this.setVersion(artifact.getVersion());
    }

    private String filterEmptyString(String in) {
        if ("".equals(in)) {
            return null;
        }
        return in;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifact) {
        this.artifactId = this.filterEmptyString(artifact);
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = this.filterEmptyString(groupId);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.filterEmptyString(type);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = this.filterEmptyString(version);
    }

    public String getBaseVersion() {
        return ArtifactUtils.toSnapshotVersion(this.version);
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = this.filterEmptyString(classifier);
    }

    public String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + StringUtils.defaultString(this.version, "?") + ":" + this.type;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.classifier + ":" + StringUtils.defaultString(this.version, "?") + ":" + this.type;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public void setExtension(String extension) {
        this.extension = this.filterEmptyString(extension);
    }

    @Override
    public String getExtension() {
        return this.extension != null ? this.extension : "jar";
    }

    public ArtifactCoords getArtifactCoords() {
        return new ArtifactCoords(this.groupId, this.artifactId, this.version, this.classifier, this.extension);
    }
}

