/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityProvider;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedFeatureParam;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.type.FeatureParameterType;
import org.jboss.galleon.type.ParameterTypeConversionException;
import org.jboss.galleon.type.ParameterTypeNotFoundException;
import org.jboss.galleon.type.ParameterTypeProvider;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ResolvedFeatureSpec
extends CapabilityProvider {
    final ResolvedSpecId id;
    final FeatureSpec xmlSpec;
    private Map<String, ResolvedFeatureParam> resolvedParamSpecs = Collections.emptyMap();
    private Map<String, ResolvedFeatureSpec> resolvedRefTargets;
    private Map<ResolvedFeatureId, FeatureDependencySpec> resolvedDeps;
    final boolean parentChildrenBranch;
    private final Boolean branchBatch;
    private final Boolean specBranch;

    public ResolvedFeatureSpec(ResolvedSpecId specId, ParameterTypeProvider typeProvider, FeatureSpec spec) throws ProvisioningException {
        FeatureAnnotation newFb;
        this.id = specId;
        this.xmlSpec = spec;
        if (this.xmlSpec.hasParams()) {
            for (Map.Entry<String, FeatureParameterSpec> entry : this.xmlSpec.getParams().entrySet()) {
                FeatureParameterSpec param = entry.getValue();
                this.resolvedParamSpecs = CollectionUtils.put(this.resolvedParamSpecs, param.getName(), this.resolveParamSpec(param, typeProvider));
            }
        }
        if ((newFb = this.xmlSpec.getAnnotation("feature-branch")) != null) {
            this.parentChildrenBranch = newFb.hasElement("parent-children");
            Boolean specBranch = null;
            String elem = newFb.getElement("spec");
            if (elem != null) {
                if (this.parentChildrenBranch) {
                    throw new ProvisioningDescriptionException(specId + " can contain either " + "parent-children" + " or " + "spec" + " element of " + "feature-branch" + " annotation");
                }
                specBranch = Boolean.parseBoolean(elem);
            }
            this.specBranch = specBranch;
            elem = newFb.getElement("batch");
            this.branchBatch = elem == null ? null : Boolean.valueOf(Boolean.parseBoolean(elem));
        } else {
            this.parentChildrenBranch = false;
            this.specBranch = null;
            this.branchBatch = null;
        }
    }

    boolean isSpecBranch(boolean defaultValue) {
        return this.specBranch == null ? defaultValue : this.specBranch;
    }

    boolean isBatchBranch(boolean defaultValue) {
        return this.branchBatch == null ? defaultValue : this.branchBatch;
    }

    private ResolvedFeatureParam resolveParamSpec(FeatureParameterSpec paramSpec, ParameterTypeProvider typeProvider) throws ProvisioningException {
        FeatureParameterType type;
        try {
            type = typeProvider.getType(this.id.gav.toGa(), paramSpec.getType());
        }
        catch (ParameterTypeNotFoundException e) {
            throw new ProvisioningException(Errors.failedToResolveParameter(this.id, paramSpec.getName()), e);
        }
        return new ResolvedFeatureParam(paramSpec, type);
    }

    public ResolvedSpecId getId() {
        return this.id;
    }

    public String getName() {
        return this.id.name;
    }

    public FeatureSpec getSpec() {
        return this.xmlSpec;
    }

    public boolean hasAnnotations() {
        return this.xmlSpec.hasAnnotations();
    }

    public Collection<FeatureAnnotation> getAnnotations() {
        return this.xmlSpec.getAnnotations();
    }

    public boolean hasParams() {
        return !this.resolvedParamSpecs.isEmpty();
    }

    public Set<String> getParamNames() {
        return this.resolvedParamSpecs.keySet();
    }

    Map<String, ResolvedFeatureParam> getResolvedParams() {
        return this.resolvedParamSpecs;
    }

    ResolvedFeatureParam getResolvedParam(String name) throws ProvisioningDescriptionException {
        ResolvedFeatureParam p = this.resolvedParamSpecs.get(name);
        if (p == null) {
            throw new ProvisioningDescriptionException(Errors.unknownFeatureParameter(this.id, name));
        }
        return p;
    }

    Map<String, Object> resolveNonIdParams(ResolvedFeatureId parentId, String parentRef, Map<String, String> params) throws ProvisioningException {
        FeatureReferenceSpec refSpec;
        Map<String, Object> resolvedParams = Collections.emptyMap();
        if (!params.isEmpty()) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (this.xmlSpec.getParam(param.getKey()).isFeatureId()) continue;
                resolvedParams = CollectionUtils.put(resolvedParams, param.getKey(), this.paramFromString(param.getKey(), param.getValue()));
            }
        }
        if (parentId == null) {
            return resolvedParams;
        }
        if (parentRef == null) {
            parentRef = parentId.specId.name;
        }
        if ((refSpec = this.xmlSpec.getFeatureRef(parentRef)).hasMappedParams()) {
            for (Map.Entry<String, Object> entry : refSpec.getMappedParams().entrySet()) {
                Object idValue;
                if (this.xmlSpec.getParam(entry.getKey()).isFeatureId() || (idValue = parentId.params.get(entry.getValue())) == null) continue;
                resolvedParams = CollectionUtils.put(resolvedParams, entry.getKey(), idValue);
            }
        } else {
            for (Map.Entry<String, Object> entry : parentId.params.entrySet()) {
                if (this.xmlSpec.getParam(entry.getKey()).isFeatureId()) continue;
                resolvedParams = CollectionUtils.put(resolvedParams, entry.getKey(), entry.getValue());
            }
        }
        return resolvedParams;
    }

    private Object paramFromString(String name, String value) throws ProvisioningException {
        try {
            return this.getResolvedParam((String)name).type.fromString(value);
        }
        catch (ParameterTypeConversionException e) {
            throw new ProvisioningException(Errors.failedToResolveParameter(this.id, name, value), e);
        }
    }

    String paramToString(String name, Object value) throws ProvisioningException {
        return this.getResolvedParam((String)name).type.toString(value);
    }

    boolean resolveCapabilityElement(ResolvedFeature feature, String paramName, CapabilityResolver capResolver) throws ProvisioningException {
        ResolvedFeatureParam resolvedParam = this.getResolvedParam(paramName);
        Object value = feature.getResolvedParam(paramName);
        if (value == null) {
            Object object = value = feature.isUnset(paramName) ? null : resolvedParam.defaultValue;
            if (value == null) {
                if (capResolver.getSpec().isOptional()) {
                    return false;
                }
                throw new ProvisioningException(Errors.capabilityMissingParameter(capResolver.getSpec(), paramName));
            }
        }
        return resolvedParam.type.resolveCapabilityElement(capResolver, value);
    }

    FeatureParameterType getTypeForParameter(String paramName) throws ParameterTypeNotFoundException, ProvisioningDescriptionException {
        return this.getResolvedParam((String)paramName).type;
    }

    ResolvedFeatureId resolveIdFromForeignKey(ResolvedFeatureId parentId, String parentRef, Map<String, String> params) throws ProvisioningException {
        if (!this.xmlSpec.hasId()) {
            return null;
        }
        if (parentId == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to initialize foreign key parameters of ").append(this.id).append(": the referenced feature has not ID ");
            throw new ProvisioningException(buf.toString());
        }
        if (parentRef == null) {
            parentRef = parentId.specId.name;
        }
        List<FeatureParameterSpec> idParamSpecs = this.xmlSpec.getIdParams();
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>(idParamSpecs.size());
        FeatureReferenceSpec refSpec = this.xmlSpec.getFeatureRef(parentRef);
        try {
            if (refSpec.hasMappedParams()) {
                for (Map.Entry<String, String> mapping : refSpec.getMappedParams().entrySet()) {
                    FeatureParameterSpec param = this.xmlSpec.getParam(mapping.getKey());
                    if (!param.isFeatureId()) continue;
                    Object idValue = parentId.params.get(mapping.getValue());
                    if (idValue == null) {
                        throw new ProvisioningDescriptionException(this.id + " expects ID parameter '" + mapping.getValue() + "' in " + parentId);
                    }
                    resolvedParams.put(mapping.getKey(), idValue);
                }
                for (FeatureParameterSpec idParamSpec : idParamSpecs) {
                    Object childValue;
                    String configValue = params.get(idParamSpec.getName());
                    if (configValue != null) {
                        childValue = this.paramFromString(idParamSpec.getName(), configValue);
                        Object idValue = resolvedParams.put(idParamSpec.getName(), childValue);
                        if (idValue == null || idValue.equals(childValue)) continue;
                        throw new ProvisioningDescriptionException(Errors.idParamForeignKeyInitConflict(this.id, idParamSpec.getName(), childValue, idValue));
                    }
                    if (resolvedParams.containsKey(idParamSpec.getName())) continue;
                    childValue = this.getResolvedParam((String)idParamSpec.getName()).defaultValue;
                    if (childValue == null) {
                        throw new ProvisioningDescriptionException(Errors.nonNillableParameterIsNull(this.id, idParamSpec.getName()));
                    }
                    resolvedParams.put(idParamSpec.getName(), childValue);
                }
            } else {
                for (FeatureParameterSpec idParamSpec : idParamSpecs) {
                    Object childValue;
                    Object parentValue = parentId.params.get(idParamSpec.getName());
                    String configValue = params.get(idParamSpec.getName());
                    if (configValue != null) {
                        childValue = this.paramFromString(idParamSpec.getName(), configValue);
                        if (parentValue != null && !parentValue.equals(childValue)) {
                            throw new ProvisioningDescriptionException(Errors.idParamForeignKeyInitConflict(this.id, idParamSpec.getName(), childValue, parentValue));
                        }
                        resolvedParams.put(idParamSpec.getName(), childValue);
                        continue;
                    }
                    if (parentValue != null) {
                        resolvedParams.put(idParamSpec.getName(), parentValue);
                        continue;
                    }
                    childValue = this.getResolvedParam((String)idParamSpec.getName()).defaultValue;
                    if (childValue == null) {
                        throw new ProvisioningDescriptionException(Errors.nonNillableParameterIsNull(this.id, idParamSpec.getName()));
                    }
                    resolvedParams.put(idParamSpec.getName(), childValue);
                }
            }
            return new ResolvedFeatureId(this.id, resolvedParams);
        }
        catch (ProvisioningException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to initialize foreign key parameters of ").append(this.id).append(" spec referencing feature ").append(parentId).append(" with parameters ");
            StringUtils.append(buf, params.entrySet());
            throw new ProvisioningException(Errors.failedToInitializeForeignKeyParams(this.id, parentId, params), e);
        }
    }

    ResolvedFeatureId resolveFeatureId(Map<String, String> params) throws ProvisioningException {
        if (!this.xmlSpec.hasId()) {
            return null;
        }
        List<FeatureParameterSpec> idSpecs = this.xmlSpec.getIdParams();
        if (idSpecs.size() == 1) {
            FeatureParameterSpec idSpec = idSpecs.get(0);
            return new ResolvedFeatureId(this.id, Collections.singletonMap(idSpec.getName(), this.resolveIdParamValue(params, idSpec)));
        }
        HashMap<String, Object> resolvedParams = new HashMap<String, Object>(idSpecs.size());
        for (FeatureParameterSpec param : idSpecs) {
            resolvedParams.put(param.getName(), this.resolveIdParamValue(params, param));
        }
        return new ResolvedFeatureId(this.id, resolvedParams);
    }

    private Object resolveIdParamValue(Map<String, String> params, FeatureParameterSpec param) throws ProvisioningException {
        ResolvedFeatureParam resolvedParam = this.getResolvedParam(param.getName());
        String strValue = params.get(param.getName());
        if (strValue == null) {
            Object value = resolvedParam.defaultValue;
            if (value == null) {
                throw new ProvisioningDescriptionException(Errors.nonNillableParameterIsNull(this.id, param.getName()));
            }
            return value;
        }
        return resolvedParam.type.fromString(strValue);
    }

    private Map<ResolvedFeatureId, FeatureDependencySpec> resolveSpecDeps(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        if (this.resolvedDeps != null) {
            return this.resolvedDeps;
        }
        this.resolvedDeps = Collections.emptyMap();
        if (this.xmlSpec.hasFeatureDeps()) {
            this.resolvedDeps = this.resolveFeatureDeps(rt, this.xmlSpec.getFeatureDeps());
        }
        return this.resolvedDeps;
    }

    Map<ResolvedFeatureId, FeatureDependencySpec> resolveFeatureDeps(ProvisioningRuntimeBuilder rt, Collection<FeatureDependencySpec> depSpecs) throws ProvisioningException {
        LinkedHashMap<ResolvedFeatureId, FeatureDependencySpec> result;
        if (depSpecs.isEmpty()) {
            return this.resolveSpecDeps(rt);
        }
        Map<ResolvedFeatureId, FeatureDependencySpec> resolvedSpecDeps = this.resolveSpecDeps(rt);
        if (resolvedSpecDeps.isEmpty()) {
            if (depSpecs.size() == 1) {
                FeatureDependencySpec depSpec = depSpecs.iterator().next();
                FeaturePackRuntimeBuilder depFp = depSpec.getOrigin() == null ? rt.getFpBuilder(this.id.gav) : rt.getOrigin(depSpec.getOrigin());
                ResolvedFeatureSpec depResolvedSpec = rt.getFeatureSpec(depFp, depSpec.getFeatureId().getSpec().getName());
                return Collections.singletonMap(depResolvedSpec.resolveFeatureId(depSpec.getFeatureId().getParams()), depSpec);
            }
            result = new LinkedHashMap(depSpecs.size());
        } else {
            result = new LinkedHashMap<ResolvedFeatureId, FeatureDependencySpec>(resolvedSpecDeps.size() + depSpecs.size());
            result.putAll(resolvedSpecDeps);
        }
        FeaturePackRuntimeBuilder ownFp = rt.getFpBuilder(this.id.gav);
        for (FeatureDependencySpec userDep : depSpecs) {
            FeaturePackRuntimeBuilder depFp = userDep.getOrigin() == null ? ownFp : rt.getOrigin(userDep.getOrigin());
            ResolvedFeatureSpec depResolvedSpec = rt.getFeatureSpec(depFp, userDep.getFeatureId().getSpec().getName());
            ResolvedFeatureId depId = depResolvedSpec.resolveFeatureId(userDep.getFeatureId().getParams());
            FeatureDependencySpec specDep = result.put(depId, userDep);
            if (specDep == null || userDep.isInclude() || !specDep.isInclude()) continue;
            result.put(depId, specDep);
        }
        return result;
    }

    void resolveRefMappings(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        if (!this.xmlSpec.hasFeatureRefs()) {
            this.resolvedRefTargets = Collections.emptyMap();
            return;
        }
        FeaturePackRuntimeBuilder ownFp = rt.getFpBuilder(this.id.gav);
        Collection<FeatureReferenceSpec> refs = this.xmlSpec.getFeatureRefs();
        if (refs.size() == 1) {
            this.resolvedRefTargets = Collections.singletonMap(refs.iterator().next().getName(), this.resolveRefMapping(rt, ownFp, refs.iterator().next()));
            return;
        }
        HashMap<String, ResolvedFeatureSpec> tmp = new HashMap<String, ResolvedFeatureSpec>(refs.size());
        for (FeatureReferenceSpec refSpec : refs) {
            tmp.put(refSpec.getName(), this.resolveRefMapping(rt, ownFp, refSpec));
        }
        this.resolvedRefTargets = Collections.unmodifiableMap(tmp);
    }

    private ResolvedFeatureSpec resolveRefMapping(ProvisioningRuntimeBuilder rt, FeaturePackRuntimeBuilder origin, FeatureReferenceSpec refSpec) throws ProvisioningException {
        try {
            if (refSpec.getOrigin() != null) {
                origin = rt.getFpBuilder(origin.spec.getFeaturePackDep(refSpec.getOrigin()).getGav());
            }
            ResolvedFeatureSpec resolvedRefSpec = rt.getFeatureSpec(origin, refSpec.getFeature().getName());
            this.assertRefParamMapping(refSpec, resolvedRefSpec);
            return resolvedRefSpec;
        }
        catch (ProvisioningDescriptionException e) {
            throw new ProvisioningDescriptionException(Errors.failedToResolveFeatureReference(refSpec, this.id), e);
        }
    }

    private void assertRefParamMapping(FeatureReferenceSpec refSpec, ResolvedFeatureSpec targetSpec) throws ProvisioningDescriptionException {
        if (!targetSpec.xmlSpec.hasId()) {
            throw new ProvisioningDescriptionException(this.id + " feature spec declares reference " + refSpec.getName() + " to feature spec " + targetSpec.id + " that has no ID parameters");
        }
        if (!refSpec.hasMappedParams()) {
            for (FeatureParameterSpec targetIdParam : targetSpec.xmlSpec.getIdParams()) {
                if (this.xmlSpec.hasParam(targetIdParam.getName())) continue;
                throw new ProvisioningDescriptionException(Errors.nonExistingForeignKeyParam(refSpec.getName(), this.id, targetIdParam.getName()));
            }
            return;
        }
        if (targetSpec.xmlSpec.getIdParams().size() != refSpec.getParamsMapped()) {
            throw new ProvisioningDescriptionException("The number of foreign key parameters of reference " + refSpec.getName() + " in feature spec " + this.id + " does not match the number of the ID parameters of the referenced feature spec " + targetSpec.id);
        }
        for (Map.Entry<String, String> mapping : refSpec.getMappedParams().entrySet()) {
            if (!this.xmlSpec.hasParam(mapping.getKey())) {
                throw new ProvisioningDescriptionException(Errors.nonExistingForeignKeyParam(refSpec.getName(), this.id, mapping.getKey()));
            }
            if (targetSpec.xmlSpec.hasParam(mapping.getValue())) continue;
            throw new ProvisioningDescriptionException(Errors.nonExistingForeignKeyTarget(mapping.getKey(), refSpec.getName(), this.id, mapping.getValue(), targetSpec.id));
        }
    }

    List<ResolvedFeatureId> resolveRefs(ResolvedFeature feature) throws ProvisioningException {
        if (this.resolvedRefTargets.isEmpty()) {
            return Collections.emptyList();
        }
        List<ResolvedFeatureId> refIds = new ArrayList<ResolvedFeatureId>(this.resolvedRefTargets.size());
        for (Map.Entry<String, ResolvedFeatureSpec> refEntry : this.resolvedRefTargets.entrySet()) {
            List<ResolvedFeatureId> resolvedIds = this.resolveRefId(feature, this.xmlSpec.getFeatureRef(refEntry.getKey()), refEntry.getValue(), false);
            if (resolvedIds.isEmpty()) continue;
            refIds = CollectionUtils.addAll(refIds, resolvedIds);
        }
        return refIds;
    }

    List<ResolvedFeatureId> resolveRefId(ResolvedFeature feature, FeatureReferenceSpec refSpec, ResolvedFeatureSpec targetSpec) throws ProvisioningException {
        return this.resolveRefId(feature, refSpec, targetSpec, true);
    }

    /*
     * WARNING - void declaration
     */
    private List<ResolvedFeatureId> resolveRefId(ResolvedFeature feature, FeatureReferenceSpec refSpec, ResolvedFeatureSpec targetSpec, boolean assertRefMapping) throws ProvisioningException {
        Map clone;
        int colI;
        Map idParams;
        int i;
        int listSize;
        Object paramValue;
        ResolvedFeatureParam resolvedParam;
        String refParamName;
        String paramName;
        boolean child;
        if (assertRefMapping) {
            this.assertRefParamMapping(refSpec, targetSpec);
        }
        ArrayList<Map<String, Object>> paramsList = null;
        Map<String, Object> params = Collections.emptyMap();
        boolean bl = child = !feature.hasId();
        if (refSpec.hasMappedParams()) {
            for (Map.Entry entry : refSpec.getMappedParams().entrySet()) {
                paramName = (String)entry.getKey();
                refParamName = (String)entry.getValue();
                resolvedParam = this.resolvedParamSpecs.get(paramName);
                if (!child && resolvedParam.spec.isFeatureId() && targetSpec.getSpec().getParam(refParamName).isFeatureId()) {
                    child = true;
                }
                if ((paramValue = feature.getResolvedParam(paramName)) == null) {
                    Object object = paramValue = feature.isUnset(paramName) ? null : resolvedParam.defaultValue;
                    if (paramValue == null) {
                        this.assertRefNotNillable(feature, refSpec);
                        return Collections.emptyList();
                    }
                }
                if (paramValue.equals("GLN_UNDEFINED")) continue;
                if (resolvedParam.type.isCollection()) {
                    Collection col = (Collection)paramValue;
                    if (col.isEmpty()) {
                        this.assertRefNotNillable(feature, refSpec);
                        return Collections.emptyList();
                    }
                    if (paramsList == null) {
                        paramsList = new ArrayList(col.size());
                        paramsList.add(params);
                    } else {
                        paramsList.ensureCapacity(paramsList.size() * col.size());
                    }
                    listSize = paramsList.size();
                    for (i = 0; i < listSize; ++i) {
                        idParams = (Map)paramsList.get(i);
                        colI = 0;
                        for (Object item : col) {
                            if (item.equals("GLN_UNDEFINED")) continue;
                            if (colI++ == 0) {
                                clone = col.size() == 1 ? idParams : CollectionUtils.clone(idParams);
                                paramsList.set(i, CollectionUtils.put(clone, refParamName, item));
                                continue;
                            }
                            paramsList.add(CollectionUtils.put(CollectionUtils.clone(idParams), refParamName, item));
                        }
                    }
                    continue;
                }
                if (paramsList != null) {
                    for (int i2 = 0; i2 < paramsList.size(); ++i2) {
                        paramsList.set(i2, CollectionUtils.put((Map)paramsList.get(i2), refParamName, paramValue));
                    }
                    continue;
                }
                params = CollectionUtils.put(params, refParamName, paramValue);
            }
        } else {
            for (FeatureParameterSpec featureParameterSpec : targetSpec.xmlSpec.getIdParams()) {
                refParamName = paramName = featureParameterSpec.getName();
                resolvedParam = this.resolvedParamSpecs.get(paramName);
                if (!child && resolvedParam.spec.isFeatureId()) {
                    child = true;
                }
                if ((paramValue = feature.getResolvedParam(paramName)) == null) {
                    Object object = paramValue = feature.isUnset(paramName) ? null : resolvedParam.defaultValue;
                    if (paramValue == null) {
                        this.assertRefNotNillable(feature, refSpec);
                        return Collections.emptyList();
                    }
                }
                if (paramValue.equals("GLN_UNDEFINED")) continue;
                if (resolvedParam.type.isCollection()) {
                    Collection col = (Collection)paramValue;
                    if (col.isEmpty()) {
                        this.assertRefNotNillable(feature, refSpec);
                        return Collections.emptyList();
                    }
                    if (paramsList == null) {
                        paramsList = new ArrayList<Map<String, Object>>(col.size());
                        paramsList.add(params);
                    } else {
                        paramsList.ensureCapacity(paramsList.size() * col.size());
                    }
                    listSize = paramsList.size();
                    for (i = 0; i < listSize; ++i) {
                        idParams = (Map)paramsList.get(i);
                        colI = 0;
                        for (Object item : col) {
                            if (item.equals("GLN_UNDEFINED")) continue;
                            if (colI++ == 0) {
                                clone = col.size() == 1 ? idParams : CollectionUtils.clone(idParams);
                                paramsList.set(i, CollectionUtils.put(clone, refParamName, item));
                                continue;
                            }
                            paramsList.add(CollectionUtils.put(CollectionUtils.clone(idParams), refParamName, item));
                        }
                    }
                    continue;
                }
                if (paramsList != null) {
                    for (int i3 = 0; i3 < paramsList.size(); ++i3) {
                        paramsList.set(i3, CollectionUtils.put((Map)paramsList.get(i3), refParamName, paramValue));
                    }
                    continue;
                }
                params = CollectionUtils.put(params, refParamName, paramValue);
            }
        }
        if (paramsList != null) {
            void var9_13;
            ArrayList<ResolvedFeatureId> refIds = new ArrayList<ResolvedFeatureId>(paramsList.size());
            boolean bl2 = false;
            while (var9_13 < paramsList.size()) {
                Map idParams2 = (Map)paramsList.get((int)var9_13);
                if (!idParams2.isEmpty()) {
                    refIds.add(new ResolvedFeatureId(targetSpec.id, idParams2, child));
                }
                ++var9_13;
            }
            if (refIds.isEmpty()) {
                this.assertRefNotNillable(feature, refSpec);
            }
            return refIds;
        }
        if (params.isEmpty()) {
            this.assertRefNotNillable(feature, refSpec);
            return Collections.emptyList();
        }
        return Collections.singletonList(new ResolvedFeatureId(targetSpec.id, params, child));
    }

    private void assertRefNotNillable(ResolvedFeature feature, FeatureReferenceSpec refSpec) throws ProvisioningDescriptionException {
        if (!refSpec.isNillable()) {
            throw new ProvisioningDescriptionException(Errors.nonNillableRefIsNull(feature, refSpec.getName()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.resolvedDeps == null ? 0 : this.resolvedDeps.hashCode());
        result = 31 * result + (this.resolvedParamSpecs == null ? 0 : this.resolvedParamSpecs.hashCode());
        result = 31 * result + (this.resolvedRefTargets == null ? 0 : this.resolvedRefTargets.hashCode());
        result = 31 * result + (this.xmlSpec == null ? 0 : this.xmlSpec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvedFeatureSpec other = (ResolvedFeatureSpec)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.resolvedDeps == null ? other.resolvedDeps != null : !this.resolvedDeps.equals(other.resolvedDeps)) {
            return false;
        }
        if (this.resolvedParamSpecs == null ? other.resolvedParamSpecs != null : !this.resolvedParamSpecs.equals(other.resolvedParamSpecs)) {
            return false;
        }
        if (this.resolvedRefTargets == null ? other.resolvedRefTargets != null : !this.resolvedRefTargets.equals(other.resolvedRefTargets)) {
            return false;
        }
        return !(this.xmlSpec == null ? other.xmlSpec != null : !this.xmlSpec.equals(other.xmlSpec));
    }

    public String toString() {
        return "ResolvedFeatureSpec{id=" + this.id + ", xmlSpec=" + this.xmlSpec + ", resolvedRefTargets=" + this.resolvedRefTargets + ", resolvedDeps=" + this.resolvedDeps + '}';
    }
}

