/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class FeatureSpecXmlParser10
implements PlugableXmlParser<FeatureSpec.Builder> {
    public static final String NAMESPACE_1_0 = "urn:wildfly:pm-feature-spec:1.0";
    public static final QName ROOT_1_0 = new QName("urn:wildfly:pm-feature-spec:1.0", Element.access$000(Element.FEATURE_SPEC));

    FeatureSpecXmlParser10() {
    }

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, FeatureSpec.Builder featureBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String specName = null;
        block16: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    specName = reader.getAttributeValue(i);
                    continue block16;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (specName == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        featureBuilder.setName(specName);
        block17: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ANNOTATION: {
                            this.parseAnnotation(reader, featureBuilder);
                            continue block17;
                        }
                        case DEPENDENCIES: {
                            this.parseDependencies(reader, featureBuilder);
                            continue block17;
                        }
                        case REFERENCES: {
                            this.parseReferences(reader, featureBuilder);
                            continue block17;
                        }
                        case PARAMETERS: {
                            this.parseParameters(reader, featureBuilder);
                            continue block17;
                        }
                        case PACKAGES: {
                            PackageDepsSpecXmlParser.parsePackageDeps(Element.PACKAGES, reader, featureBuilder);
                            continue block17;
                        }
                        case PROVIDES: {
                            this.parseCapabilities(reader, featureBuilder, true);
                            continue block17;
                        }
                        case REQUIRES: {
                            this.parseCapabilities(reader, featureBuilder, false);
                            continue block17;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseAnnotation(XMLExtendedStreamReader reader, FeatureSpec.Builder builder) throws XMLStreamException {
        String name = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        FeatureAnnotation fa = new FeatureAnnotation(name);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    builder.addAnnotation(fa);
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ELEM: {
                            this.parseAnnotationElem(reader, fa);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseAnnotationElem(XMLExtendedStreamReader reader, FeatureAnnotation fa) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        fa.setElement(name, value);
    }

    private void parseDependencies(XMLExtendedStreamReader reader, FeatureSpec.Builder specBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCY: {
                            try {
                                specBuilder.addFeatureDep(this.parseDependency(reader));
                                continue block9;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse feature reference", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private FeatureDependencySpec parseDependency(XMLExtendedStreamReader reader) throws XMLStreamException {
        String dependency = null;
        boolean include = false;
        String featureId = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case DEPENDENCY: {
                    dependency = reader.getAttributeValue(i);
                    continue block7;
                }
                case FEATURE_ID: {
                    featureId = reader.getAttributeValue(i);
                    continue block7;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (featureId == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.FEATURE_ID));
        }
        ParsingUtils.parseNoContent(reader);
        try {
            return FeatureDependencySpec.create(FeatureId.fromString(featureId), dependency, include);
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse feature dependency", reader.getLocation(), e);
        }
    }

    private void parseReferences(XMLExtendedStreamReader reader, FeatureSpec.Builder specBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case REFERENCE: {
                            try {
                                specBuilder.addFeatureRef(this.parseReference(reader));
                                continue block9;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to parse feature reference", e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private FeatureReferenceSpec parseReference(XMLExtendedStreamReader reader) throws XMLStreamException {
        String dependency = null;
        String name = null;
        String feature = null;
        boolean nillable = false;
        boolean include = false;
        block16: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case DEPENDENCY: {
                    dependency = reader.getAttributeValue(i);
                    continue block16;
                }
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block16;
                }
                case FEATURE: {
                    feature = reader.getAttributeValue(i);
                    continue block16;
                }
                case NILLABLE: {
                    nillable = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block16;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block16;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (feature == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.FEATURE));
        }
        if (name == null) {
            name = feature;
        }
        FeatureReferenceSpec.Builder refBuilder = FeatureReferenceSpec.builder(feature).setOrigin(dependency).setName(name).setNillable(nillable).setInclude(include);
        block17: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        return refBuilder.build();
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to parse feature reference", e);
                    }
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAMETER: {
                            this.parseRefParameter(reader, refBuilder);
                            continue block17;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseRefParameter(XMLExtendedStreamReader reader, FeatureReferenceSpec.Builder refBuilder) throws XMLStreamException {
        String name = null;
        String mapsTo = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case MAPS_TO: {
                    mapsTo = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            Set<Attribute> set;
            if (mapsTo == null) {
                set = new HashSet<Attribute>();
                set.add(Attribute.NAME);
                set.add(Attribute.MAPS_TO);
            } else {
                set = Collections.singleton(Attribute.NAME);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), set);
        }
        if (mapsTo == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.MAPS_TO));
        }
        refBuilder.mapParam(name, mapsTo);
        ParsingUtils.parseNoContent(reader);
    }

    private void parseParameters(XMLExtendedStreamReader reader, FeatureSpec.Builder specBuilder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block9: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAMETER: {
                            try {
                                specBuilder.addParam(this.parseParameter(reader));
                                continue block9;
                            }
                            catch (ProvisioningDescriptionException e) {
                                throw new XMLStreamException("Failed to add parameter to the spec", reader.getLocation(), e);
                            }
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private FeatureParameterSpec parseParameter(XMLExtendedStreamReader reader) throws XMLStreamException {
        FeatureParameterSpec.Builder builder = FeatureParameterSpec.builder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    builder.setName(reader.getAttributeValue(i));
                    continue block9;
                }
                case FEATURE_ID: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block9;
                    builder.setFeatureId();
                    continue block9;
                }
                case DEFAULT: {
                    builder.setDefaultValue(reader.getAttributeValue(i));
                    continue block9;
                }
                case NILLABLE: {
                    if (!Boolean.parseBoolean(reader.getAttributeValue(i))) continue block9;
                    builder.setNillable();
                    continue block9;
                }
                case TYPE: {
                    builder.setType(reader.getAttributeValue(i));
                    continue block9;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (builder.getName() == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        try {
            return builder.build();
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to create feature parameter", reader.getLocation(), e);
        }
    }

    private void parseCapabilities(XMLExtendedStreamReader reader, FeatureSpec.Builder spec, boolean provides) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CAPABILITY: {
                            CapabilitySpec cap = this.parseCapabilityName(reader);
                            if (provides) {
                                spec.providesCapability(cap);
                                continue block7;
                            }
                            spec.requiresCapability(cap);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private CapabilitySpec parseCapabilityName(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        boolean optional = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block6;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        try {
            return CapabilitySpec.fromString(name, optional);
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse capability '" + name + "'", reader.getLocation(), e);
        }
    }

    static enum Attribute implements XmlNameProvider
    {
        DEFAULT("default"),
        DEPENDENCY("dependency"),
        FEATURE("feature"),
        FEATURE_ID("feature-id"),
        INCLUDE("include"),
        MAPS_TO("maps-to"),
        NAME("name"),
        NILLABLE("nillable"),
        OPTIONAL("optional"),
        TYPE("type"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<QName, Attribute>(12);
            attributes.put(new QName(Attribute.DEFAULT.name), DEFAULT);
            attributes.put(new QName(Attribute.DEPENDENCY.name), DEPENDENCY);
            attributes.put(new QName(Attribute.FEATURE.name), FEATURE);
            attributes.put(new QName(Attribute.FEATURE_ID.name), FEATURE_ID);
            attributes.put(new QName(Attribute.INCLUDE.name), INCLUDE);
            attributes.put(new QName(Attribute.MAPS_TO.name), MAPS_TO);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.NILLABLE.name), NILLABLE);
            attributes.put(new QName(Attribute.OPTIONAL.name), OPTIONAL);
            attributes.put(new QName(Attribute.TYPE.name), TYPE);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        ANNOTATION("annotation"),
        CAPABILITY("capability"),
        DEPENDENCIES("deps"),
        DEPENDENCY("dep"),
        ELEM("elem"),
        FEATURE_PACK("feature-pack"),
        FEATURE_SPEC("feature-spec"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PARAMETER("param"),
        PARAMETERS("params"),
        PROVIDES("provides"),
        REFERENCE("ref"),
        REFERENCES("refs"),
        REQUIRES("requires"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:wildfly:pm-feature-spec:1.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return FeatureSpecXmlParser10.NAMESPACE_1_0;
        }

        public String toString() {
            return this.name;
        }

        static /* synthetic */ String access$000(Element x0) {
            return x0.name;
        }

        static {
            elements = new HashMap<QName, Element>(16);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.ANNOTATION.name), ANNOTATION);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.CAPABILITY.name), CAPABILITY);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.DEPENDENCIES.name), DEPENDENCIES);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.DEPENDENCY.name), DEPENDENCY);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.ELEM.name), ELEM);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.FEATURE_PACK.name), FEATURE_PACK);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.FEATURE_SPEC.name), FEATURE_SPEC);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.PACKAGE.name), PACKAGE);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.PACKAGES.name), PACKAGES);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.PARAMETER.name), PARAMETER);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.PARAMETERS.name), PARAMETERS);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.PROVIDES.name), PROVIDES);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.REFERENCE.name), REFERENCE);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.REFERENCES.name), REFERENCES);
            elements.put(new QName(FeatureSpecXmlParser10.NAMESPACE_1_0, Element.REQUIRES.name), REQUIRES);
            elements.put(null, UNKNOWN);
        }
    }
}

