/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;

public class ProvisionedConfigBuilder
implements ProvisionedConfig {
    private String model;
    private String name;
    private Map<String, String> props = Collections.emptyMap();
    private List<ProvisionedFeature> features = Collections.emptyList();

    public static ProvisionedConfigBuilder builder() {
        return new ProvisionedConfigBuilder();
    }

    private ProvisionedConfigBuilder() {
    }

    public ProvisionedConfigBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ProvisionedConfigBuilder setModel(String model) {
        this.model = model;
        return this;
    }

    public ProvisionedConfigBuilder setProperty(String name, String value) {
        switch (this.props.size()) {
            case 0: {
                this.props = Collections.singletonMap(name, value);
                break;
            }
            case 1: {
                Map.Entry<String, String> entry = this.props.entrySet().iterator().next();
                this.props = new HashMap<String, String>(2);
                this.props.put(entry.getKey(), entry.getValue());
            }
            default: {
                this.props.put(name, value);
            }
        }
        return this;
    }

    public ProvisionedConfigBuilder addFeature(ProvisionedFeature feature) {
        switch (this.features.size()) {
            case 0: {
                this.features = Collections.singletonList(feature);
                break;
            }
            case 1: {
                ProvisionedFeature first = this.features.get(0);
                this.features = new ArrayList<ProvisionedFeature>(2);
                this.features.add(first);
            }
            default: {
                this.features.add(feature);
            }
        }
        return this;
    }

    public ProvisionedConfig build() {
        if (this.props.size() > 1) {
            this.props = Collections.unmodifiableMap(this.props);
        }
        if (this.features.size() > 1) {
            this.features = Collections.unmodifiableList(this.features);
        }
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public boolean hasProperties() {
        return !this.props.isEmpty();
    }

    @Override
    public String getProperty(String name) {
        return this.props.get(name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.props;
    }

    @Override
    public boolean hasFeatures() {
        return !this.features.isEmpty();
    }

    @Override
    public void handle(ProvisionedConfigHandler handler) throws ProvisioningException {
        if (!this.hasFeatures()) {
            return;
        }
        handler.prepare(this);
        ResolvedSpecId lastHandledSpecId = null;
        for (ProvisionedFeature feature : this.features) {
            if (!feature.getSpecId().equals(lastHandledSpecId)) {
                if (lastHandledSpecId == null || !feature.getSpecId().getGav().equals(lastHandledSpecId.getGav())) {
                    handler.nextFeaturePack(feature.getSpecId().getGav());
                }
                handler.nextSpec(new ResolvedFeatureSpec(feature.getSpecId(), null, FeatureSpec.builder().build()));
                lastHandledSpecId = feature.getSpecId();
            }
            handler.nextFeature(feature);
        }
        handler.done();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedConfigBuilder other = (ProvisionedConfigBuilder)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.props == null ? other.props != null : !this.props.equals(other.props));
    }

    public String toString() {
        Iterator<Object> i;
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.model != null) {
            buf.append("model=").append(this.model).append(' ');
        }
        if (this.name != null) {
            buf.append("name=").append(this.name).append(' ');
        }
        if (!this.props.isEmpty()) {
            buf.append("props={");
            i = this.props.entrySet().iterator();
            Map.Entry entry = i.next();
            buf.append(entry.getKey()).append('=').append(entry.getValue());
            while (i.hasNext()) {
                entry = (Map.Entry)i.next();
                buf.append(',').append((String)entry.getKey()).append('=').append((String)entry.getValue());
            }
            buf.append("} ");
        }
        if (!this.features.isEmpty()) {
            buf.append("features={");
            i = this.features.iterator();
            buf.append(i.next());
            while (i.hasNext()) {
                buf.append(',').append(i.next());
            }
            buf.append('}');
        }
        return buf.append(']').toString();
    }
}

