/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisionedFeatureBuilder
implements ProvisionedFeature {
    private final ResolvedSpecId specId;
    private ResolvedFeatureId id;
    private ResolvedFeatureId.Builder idBuilder;
    private Map<String, String> configParams = Collections.emptyMap();

    public static ProvisionedFeatureBuilder builder(ResolvedFeatureId id) {
        return new ProvisionedFeatureBuilder(id, id.getSpecId());
    }

    public static ProvisionedFeatureBuilder builder(ResolvedSpecId id) {
        return new ProvisionedFeatureBuilder(null, id);
    }

    private ProvisionedFeatureBuilder(ResolvedFeatureId id, ResolvedSpecId specId) {
        this.id = id;
        this.specId = specId;
        if (id != null) {
            Map<String, Object> idParams = id.getParams();
            if (idParams.size() > 1) {
                this.configParams = new HashMap<String, String>(idParams.size());
                for (Map.Entry<String, Object> entry : idParams.entrySet()) {
                    this.configParams.put(entry.getKey(), (String)entry.getValue());
                }
            } else {
                Map.Entry<String, Object> entry = idParams.entrySet().iterator().next();
                this.configParams = Collections.singletonMap(entry.getKey(), (String)entry.getValue());
            }
            this.idBuilder = null;
        } else {
            this.idBuilder = ResolvedFeatureId.builder(specId);
        }
    }

    public ProvisionedFeatureBuilder setConfigParam(String name, String value) {
        this.configParams = CollectionUtils.put(this.configParams, name, value);
        return this;
    }

    public ProvisionedFeatureBuilder setIdParam(String name, String value) {
        if (this.idBuilder == null) {
            throw new IllegalStateException("The ID builder has not been initialized");
        }
        this.idBuilder.setParam(name, value);
        this.setConfigParam(name, value);
        return this;
    }

    public ProvisionedFeature build() throws ProvisioningDescriptionException {
        if (this.idBuilder != null) {
            this.id = this.idBuilder.build();
            this.idBuilder = null;
        }
        if (this.configParams.size() > 1) {
            this.configParams = Collections.unmodifiableMap(this.configParams);
        }
        return this;
    }

    @Override
    public boolean hasId() {
        return this.id != null;
    }

    @Override
    public ResolvedFeatureId getId() {
        return this.id;
    }

    @Override
    public ResolvedSpecId getSpecId() {
        return this.specId;
    }

    @Override
    public boolean hasParams() {
        return !this.configParams.isEmpty();
    }

    @Override
    public Collection<String> getParamNames() {
        return this.configParams.keySet();
    }

    @Override
    public Object getResolvedParam(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getConfigParam(String name) throws ProvisioningException {
        return this.configParams.get(name);
    }

    @Override
    public Map<String, Object> getResolvedParams() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configParams == null ? 0 : this.configParams.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.specId == null ? 0 : this.specId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedFeatureBuilder other = (ProvisionedFeatureBuilder)obj;
        if (this.configParams == null ? other.configParams != null : !this.configParams.equals(other.configParams)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.specId == null ? other.specId != null : !this.specId.equals(other.specId));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.id != null) {
            buf.append(this.id);
        } else {
            buf.append(this.specId);
        }
        if (!this.configParams.isEmpty()) {
            buf.append(" config-params:{");
            StringUtils.append(buf, this.configParams.entrySet());
            buf.append('}');
        }
        return buf.append(']').toString();
    }
}

