/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Singleton;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.util.artifact.SubArtifact;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;

@Singleton
public class MavenPluginUtil
extends AbstractLogEnabled {
    public InstallRequest getInstallLayoutRequest(Path layoutDir, MavenProject project) throws IOException {
        File pomFile = project.getFile();
        Logger logger = this.getLogger();
        InstallRequest installReq = new InstallRequest();
        Throwable throwable = null;
        Object var7_8 = null;
        try (DirectoryStream<Path> wdStream = Files.newDirectoryStream(layoutDir, entry -> Files.isDirectory(entry, new LinkOption[0]));){
            for (Path groupDir : wdStream) {
                String groupId = groupDir.getFileName().toString();
                Throwable throwable2 = null;
                Object var13_16 = null;
                try (DirectoryStream<Path> groupStream = Files.newDirectoryStream(groupDir);){
                    for (Path artifactDir : groupStream) {
                        String artifactId = artifactDir.getFileName().toString();
                        Throwable throwable3 = null;
                        Object var19_24 = null;
                        try (DirectoryStream<Path> artifactStream = Files.newDirectoryStream(artifactDir);){
                            for (Path versionDir : artifactStream) {
                                Path zippedFP;
                                if (logger.isDebugEnabled()) {
                                    logger.debug("Preparing feature-pack " + versionDir.toAbsolutePath());
                                }
                                if (Files.exists(zippedFP = layoutDir.resolve(String.valueOf(groupId) + '_' + artifactId + '_' + versionDir.getFileName().toString() + ".zip"), new LinkOption[0])) {
                                    IoUtils.recursiveDelete(zippedFP);
                                }
                                ZipUtils.zip(versionDir, zippedFP);
                                DefaultArtifact artifact = new DefaultArtifact(groupDir.getFileName().toString(), artifactDir.getFileName().toString(), null, "zip", versionDir.getFileName().toString(), null, zippedFP.toFile());
                                Path target = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(String.valueOf(project.getBuild().getFinalName()) + ".zip");
                                IoUtils.copy(zippedFP, target);
                                installReq.addArtifact(artifact);
                                if (pomFile == null || !Files.exists(pomFile.toPath(), new LinkOption[0])) continue;
                                Artifact pomArtifact = new SubArtifact(artifact, "", "pom");
                                pomArtifact = pomArtifact.setFile(pomFile);
                                installReq.addArtifact(pomArtifact);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return installReq;
    }
}

