/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.impl.parser.AeshCommandLineParser;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapProcessedCommandBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.model.state.State;

public abstract class AbstractDynamicCommand
extends MapCommand<PmCommandInvocation> {
    public static final String ARGUMENT_NAME = "org.jboss.pm.tool.arg";
    private final Map<String, List<ProcessedOption>> dynamicOptions = new HashMap<String, List<ProcessedOption>>();
    private final Map<String, String> renamedOptions = new HashMap<String, String>();
    protected final PmSession pmSession;
    private final Set<String> staticOptions = new HashSet<String>();
    private final Set<String> noValuesOptions = new HashSet<String>();
    private ProcessedCommand<?> cmd;

    public AbstractDynamicCommand(PmSession pmSession) {
        this.pmSession = pmSession;
    }

    protected abstract String getId(PmSession var1);

    protected abstract String getName();

    protected abstract String getDescription();

    protected abstract List<DynamicOption> getDynamicOptions(State var1, String var2) throws Exception;

    protected abstract void runCommand(PmCommandInvocation var1, Map<String, String> var2) throws CommandExecutionException;

    protected abstract List<ProcessedOption> getStaticOptions() throws OptionParserException;

    protected abstract PmCommandActivator getActivator();

    public CommandContainer<Command<PmCommandInvocation>, PmCommandInvocation> createCommand() throws CommandLineParserException {
        this.cmd = this.buildCommand();
        AeshCommandContainer<Command<PmCommandInvocation>, PmCommandInvocation> container = new AeshCommandContainer<Command<PmCommandInvocation>, PmCommandInvocation>(new AeshCommandLineParser(this.cmd));
        return container;
    }

    @Override
    public CommandResult execute(PmCommandInvocation session) throws CommandException {
        try {
            this.validateOptions();
            Map<String, String> options = this.getOptions();
            this.runCommand(session, options);
            return CommandResult.SUCCESS;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                t.printStackTrace(session.getErr());
            }
            session.print("Error: ");
            this.println(session, t);
            t = t.getCause();
            int offset = 1;
            while (t != null) {
                for (int i = 0; i < offset; ++i) {
                    session.print(" ");
                }
                session.print("* ");
                this.println(session, t);
                t = t.getCause();
                ++offset;
            }
            return CommandResult.FAILURE;
        }
    }

    protected String getArgumentValue() {
        return this.cmd.getArgument().getValue();
    }

    protected List<String> getArgumentsValues() {
        return this.cmd.getArguments().getValues();
    }

    private String rename(String name, List<DynamicOption> options) {
        throw new RuntimeException("TODO Must rename " + name);
    }

    private ProcessedCommand buildCommand() throws CommandLineParserException {
        MapProcessedCommandBuilder builder = new MapProcessedCommandBuilder();
        builder.command(this);
        builder.name(this.getName());
        builder.activator(this.getActivator());
        List<ProcessedOption> otherOptions = this.getStaticOptions();
        for (ProcessedOption o : otherOptions) {
            this.staticOptions.add(o.name());
            if (o.name().equals(ARGUMENT_NAME)) {
                if (o.hasMultipleValues()) {
                    builder.arguments(o);
                    continue;
                }
                builder.argument(o);
                continue;
            }
            builder.addOption(o);
        }
        builder.description(this.getDescription());
        builder.optionProvider(new DynamicOptionsProvider());
        return builder.create();
    }

    private void validateOptions() throws CommandException {
        for (String o : this.getValues().keySet()) {
            boolean found = false;
            if (ARGUMENT_NAME.equals(o)) continue;
            for (ProcessedOption opt : this.cmd.getOptions()) {
                if (!opt.name().equals(o)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new CommandException("Unknown option " + o);
        }
        this.doValidateOptions();
    }

    protected abstract void doValidateOptions() throws CommandException;

    private void println(PmCommandInvocation session, Throwable t) {
        if (t.getLocalizedMessage() == null) {
            session.println(t.getClass().getName());
        } else {
            session.println(t.getLocalizedMessage());
        }
    }

    private Map<String, String> getOptions() throws CommandException {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String m : this.getValues().keySet()) {
            if (m == null || m.isEmpty()) {
                throw new CommandException("Invalid null option");
            }
            if (this.staticOptions.contains(m)) continue;
            if (this.noValuesOptions.contains(m)) {
                options.put(m, null);
                continue;
            }
            options.put(m, (String)this.getValue(m));
        }
        return options;
    }

    private class DynamicOptionsProvider
    implements MapProcessedCommandBuilder.ProcessedOptionProvider {
        private DynamicOptionsProvider() {
        }

        @Override
        public List<ProcessedOption> getOptions(List<ProcessedOption> currentOptions) {
            try {
                String id = AbstractDynamicCommand.this.getId(AbstractDynamicCommand.this.pmSession);
                if (id != null) {
                    ArrayList<ProcessedOption> options = (ArrayList<ProcessedOption>)AbstractDynamicCommand.this.dynamicOptions.get(id);
                    if (options == null) {
                        options = new ArrayList<ProcessedOption>();
                        List<DynamicOption> parameters = AbstractDynamicCommand.this.getDynamicOptions(AbstractDynamicCommand.this.pmSession.getState(), id);
                        for (DynamicOption opt : parameters) {
                            ProcessedOptionBuilder builder = ProcessedOptionBuilder.builder();
                            if (AbstractDynamicCommand.this.staticOptions.contains(opt.getName())) {
                                AbstractDynamicCommand.this.renamedOptions.put(AbstractDynamicCommand.this.rename(opt.getName(), parameters), opt.getName());
                            }
                            builder.name(opt.getName());
                            builder.type(String.class);
                            if (!opt.hasValue()) {
                                AbstractDynamicCommand.this.noValuesOptions.add(opt.getName());
                            }
                            builder.optionType(opt.hasValue() ? OptionType.NORMAL : OptionType.BOOLEAN);
                            builder.hasValue(opt.hasValue());
                            builder.required(opt.isRequired());
                            if (opt.getDefaultValue() != null) {
                                builder.addDefaultValue(opt.getDefaultValue());
                            }
                            options.add(builder.build());
                        }
                        AbstractDynamicCommand.this.dynamicOptions.put(id, options);
                    }
                    return options;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Collections.emptyList();
        }
    }

    public class DynamicOption {
        private final String name;
        private final boolean hasValue;
        private final boolean required;
        private String defaultValue;

        public DynamicOption(String name, boolean required, boolean hasValue) {
            this.name = name;
            this.required = required;
            this.hasValue = hasValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasValue() {
            return this.hasValue;
        }

        public boolean isRequired() {
            return this.required;
        }
    }
}

