/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.FeatureParameterSpec;

public class ConfigProvisioning {
    private static boolean featureExists(ConfigModel cm, FeatureId featId) {
        for (ConfigItem ci : cm.getItems()) {
            FeatureConfig fi;
            if (!(ci instanceof FeatureConfig) || !(fi = (FeatureConfig)ci).getSpecId().equals(featId.getSpec())) continue;
            boolean eq = true;
            for (String name : featId.getParamNames()) {
                String p = fi.getParam(name);
                if (p != null && p.equals(featId.getParam(name))) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            return true;
        }
        return false;
    }

    State.Action resetConfiguration(ConfigId id) {
        return new ResetConfigurationAction(id);
    }

    State.Action addFeature(ConfigId id, FeatureSpecInfo spec, Map<String, String> options) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new AddFeatureAction(id, spec, options);
    }

    State.Action removeFeature(ConfigId id, FeatureInfo fi) throws ProvisioningDescriptionException, ProvisioningException, IOException {
        return new RemoveFeatureAction(id, fi);
    }

    private class RemoveFeatureAction
    implements State.Action {
        private final ConfigId id;
        private final FeatureInfo feature;
        private ConfigModel.Builder targetConfig;
        private boolean newConfig;
        private boolean exclude;

        RemoveFeatureAction(ConfigId id, FeatureInfo feature) {
            this.id = id;
            this.feature = feature;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            for (ConfigModel cm : current.getDefinedConfigs()) {
                if (!cm.getName().equals(this.id.getName()) || !cm.getModel().equals(this.id.getModel())) continue;
                this.targetConfig = cm.getBuilder();
                this.exclude = !ConfigProvisioning.featureExists(cm, this.feature.getFeatureId());
                break;
            }
            if (this.targetConfig == null) {
                if (!current.isInheritConfigs() && !current.getIncludedConfigs().contains(this.id)) {
                    throw new ProvisioningException("Unknown config " + this.targetConfig);
                }
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
                this.targetConfig.excludeFeature(this.feature.getFeatureId());
            } else {
                builder.removeConfig(this.id);
                if (this.exclude) {
                    this.targetConfig.excludeFeature(this.feature.getFeatureId());
                } else {
                    this.targetConfig.removeFeature(this.feature.getFeatureId());
                }
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.newConfig) {
                builder.removeConfig(this.id);
            } else {
                if (this.exclude) {
                    this.targetConfig.removeExcludedFeature(this.feature.getFeatureId());
                } else {
                    this.targetConfig.addFeature(this.feature.getFeatureConfig());
                }
                builder.removeConfig(this.id);
                builder.addConfig(this.targetConfig.build());
            }
        }
    }

    private class AddFeatureAction
    implements State.Action {
        private final ConfigId id;
        private final FeatureSpecInfo spec;
        private final Map<String, String> options;
        private ConfigModel.Builder targetConfig;
        private FeatureId featId;
        private boolean newConfig;
        private boolean isExcluded;

        AddFeatureAction(ConfigId id, FeatureSpecInfo spec, Map<String, String> options) {
            this.id = id;
            this.spec = spec;
            this.options = options;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            HashMap<String, String> ids = new HashMap<String, String>();
            HashMap<String, String> params = new HashMap<String, String>();
            for (String opt : this.options.keySet()) {
                FeatureParameterSpec featureParameterSpec = this.spec.getSpec().getParams().get(opt);
                String value = this.options.get(opt);
                if (featureParameterSpec.isFeatureId()) {
                    if ("GLN_UNDEFINED".equals(value)) continue;
                    ids.put(opt, value);
                    continue;
                }
                if (value.equals(featureParameterSpec.getDefaultValue())) continue;
                params.put(opt, value);
            }
            this.featId = new FeatureId(this.spec.getSpec().getName(), ids);
            FeatureConfig fc = FeatureConfig.newConfig(this.featId);
            for (ConfigModel configModel : current.getDefinedConfigs()) {
                if (!configModel.getName().equals(this.id.getName()) || !configModel.getModel().equals(this.id.getModel())) continue;
                this.targetConfig = configModel.getBuilder();
                if (ConfigProvisioning.featureExists(configModel, this.featId)) {
                    throw new ProvisioningException("Feature " + this.featId + "already exists in config " + this.id);
                }
                this.isExcluded = configModel.getExcludedFeatures().containsKey(this.featId);
                break;
            }
            if (this.targetConfig == null) {
                this.targetConfig = ConfigModel.builder(this.id.getModel(), this.id.getName());
                this.newConfig = true;
            }
            for (Map.Entry entry : params.entrySet()) {
                fc.setParam((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.isExcluded) {
                this.targetConfig.removeExcludedFeature(this.featId);
            } else {
                this.targetConfig.addFeature(fc);
            }
            if (!this.newConfig) {
                builder.removeConfig(this.id);
            }
            builder.addConfig(this.targetConfig.build());
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.isExcluded) {
                this.targetConfig.excludeFeature(this.featId);
            } else {
                this.targetConfig.removeFeature(this.featId);
            }
            builder.removeConfig(this.id);
            if (!this.newConfig) {
                builder.addConfig(this.targetConfig.build());
            }
        }
    }

    private class ResetConfigurationAction
    implements State.Action {
        private final ConfigId id;
        private int index;

        ResetConfigurationAction(ConfigId id) {
            this.id = id;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            boolean found = false;
            for (ConfigModel m : current.getDefinedConfigs()) {
                if (!m.getId().equals(this.id)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new ProvisioningException("Config " + this.id + " doesn't exist");
            }
            this.index = builder.getDefinedConfigIndex(this.id);
            builder.removeConfig(this.id);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.addConfig(this.index, ((ConfigModel.Builder)ConfigModel.builder().setModel(this.id.getModel()).setName(this.id.getName())).build());
        }
    }
}

