/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ConfigModel
extends FeatureGroupSupport {
    public static final String BRANCH_PER_SPEC = "config.branch-per-spec";
    public static final String BRANCH_IS_BATCH = "config.branch-is-batch";
    final ConfigId id;
    final Map<String, String> props;
    final Map<String, ConfigId> configDeps;
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String model, String name) {
        return new Builder(model, name);
    }

    protected ConfigModel(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.id = new ConfigId(builder.model, builder.name);
        this.props = CollectionUtils.unmodifiable(builder.props);
        this.configDeps = CollectionUtils.unmodifiable(builder.configDeps);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public ConfigId getId() {
        return this.id;
    }

    public String getModel() {
        return this.id.getModel();
    }

    @Override
    public boolean hasProperties() {
        return !this.props.isEmpty();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.props;
    }

    @Override
    public boolean isConfig() {
        return true;
    }

    public boolean hasConfigDeps() {
        return !this.configDeps.isEmpty();
    }

    public Map<String, ConfigId> getConfigDeps() {
        return this.configDeps;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.configDeps == null ? 0 : this.configDeps.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigModel other = (ConfigModel)obj;
        if (this.configDeps == null ? other.configDeps != null : !this.configDeps.equals(other.configDeps)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.props == null ? other.props != null : !this.props.equals(other.props));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[model=").append(this.id.getModel()).append(" name=").append(this.id.getName());
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        if (!this.props.isEmpty()) {
            buf.append(" props=");
            StringUtils.append(buf, this.props.entrySet());
        }
        if (!this.configDeps.isEmpty()) {
            buf.append(" config-deps=");
            StringUtils.append(buf, this.configDeps.entrySet());
        }
        if (!this.inheritFeatures) {
            buf.append(" inherit-features=false");
        }
        if (!this.includedSpecs.isEmpty()) {
            buf.append(" includedSpecs=");
            StringUtils.append(buf, this.includedSpecs);
        }
        if (!this.excludedSpecs.isEmpty()) {
            buf.append(" exlcudedSpecs=");
            StringUtils.append(buf, this.excludedSpecs);
        }
        if (!this.includedFeatures.isEmpty()) {
            buf.append(" includedFeatures=[");
            Iterator i = this.includedFeatures.entrySet().iterator();
            Map.Entry entry = i.next();
            buf.append(entry.getKey());
            if (entry.getValue() != null) {
                buf.append("->").append(entry.getValue());
            }
            while (i.hasNext()) {
                entry = i.next();
                buf.append(';').append(entry.getKey());
                if (entry.getValue() == null) continue;
                buf.append("->").append(entry.getValue());
            }
            buf.append(']');
        }
        if (!this.excludedFeatures.isEmpty()) {
            buf.append(" exlcudedFeatures=");
            StringUtils.append(buf, this.excludedFeatures.keySet());
        }
        if (!this.items.isEmpty()) {
            buf.append(" items=");
            StringUtils.append(buf, this.items);
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeatureGroupBuilderSupport<Builder> {
        private String model;
        private Map<String, String> props = Collections.emptyMap();
        private Map<String, ConfigId> configDeps = Collections.emptyMap();

        protected Builder() {
        }

        protected Builder(String model, String name) {
            super(name);
            this.model = model;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        @Override
        public Builder setProperty(String name, String value) {
            this.props = CollectionUtils.put(this.props, name, value);
            return this;
        }

        @Override
        public Builder setConfigDep(String depName, ConfigId configId) {
            this.configDeps = CollectionUtils.put(this.configDeps, depName, configId);
            return this;
        }

        public ConfigModel build() throws ProvisioningDescriptionException {
            return new ConfigModel(this);
        }
    }
}

