/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.AttributeValue;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.FormattingXmlStreamWriter;

abstract class BaseXmlWriter<T> {
    BaseXmlWriter() {
    }

    protected static void ensureParentDir(Path p) throws IOException {
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
    }

    protected static ElementNode addElement(ElementNode parent, XmlNameProvider e) {
        return BaseXmlWriter.addElement(parent, e.getLocalName(), e.getNamespace());
    }

    protected static ElementNode addElement(ElementNode parent, String localName, String ns) {
        ElementNode eNode = new ElementNode(parent, localName, ns);
        if (parent != null) {
            parent.addChild(eNode);
        }
        return eNode;
    }

    protected static void addAttribute(ElementNode e, XmlNameProvider name, String value) {
        BaseXmlWriter.addAttribute(e, name.getLocalName(), value);
    }

    protected static void addAttribute(ElementNode e, String name, String value) {
        e.addAttribute(name, new AttributeValue(value));
    }

    public void write(T t, Path outputFile) throws XMLStreamException, IOException {
        ElementNode root = this.toElement(t);
        BaseXmlWriter.ensureParentDir(outputFile);
        try (FormattingXmlStreamWriter writer = new FormattingXmlStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));){
            writer.writeStartDocument();
            root.marshall(writer);
            writer.writeEndDocument();
        }
    }

    protected abstract ElementNode toElement(T var1) throws XMLStreamException;
}

