/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.state.FeaturePackPackage;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedConfigXmlWriter;
import org.jboss.galleon.xml.ProvisionedStateXmlParser10;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedStateXmlWriter
extends BaseXmlWriter<FeaturePackSet<?>> {
    private static final ProvisionedStateXmlWriter INSTANCE = new ProvisionedStateXmlWriter();

    public static ProvisionedStateXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedStateXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeaturePackSet<?> provisionedState) throws XMLStreamException {
        ElementNode pkg = ProvisionedStateXmlWriter.addElement(null, ProvisionedStateXmlParser10.Element.INSTALLATION);
        if (provisionedState.hasFeaturePacks()) {
            for (FeaturePack fp : provisionedState.getFeaturePacks()) {
                ElementNode fpElement = ProvisionedStateXmlWriter.addElement(pkg, ProvisionedStateXmlParser10.Element.FEATURE_PACK);
                this.writeFeaturePack(fpElement, fp);
            }
        }
        if (provisionedState.hasConfigs()) {
            for (ProvisionedConfig config : provisionedState.getConfigs()) {
                pkg.addChild(ProvisionedConfigXmlWriter.getInstance().toElement(config));
            }
        }
        return pkg;
    }

    private void writeFeaturePack(ElementNode fp, FeaturePack<?> featurePack) {
        ProvisionedStateXmlWriter.addAttribute(fp, ProvisionedStateXmlParser10.Attribute.GROUP_ID, featurePack.getGav().getGroupId());
        ProvisionedStateXmlWriter.addAttribute(fp, ProvisionedStateXmlParser10.Attribute.ARTIFACT_ID, featurePack.getGav().getArtifactId());
        if (featurePack.getGav().getVersion() != null) {
            ProvisionedStateXmlWriter.addAttribute(fp, ProvisionedStateXmlParser10.Attribute.VERSION, featurePack.getGav().getVersion());
        }
        if (featurePack.hasPackages()) {
            ElementNode packages = ProvisionedStateXmlWriter.addElement(fp, ProvisionedStateXmlParser10.Element.PACKAGES);
            for (FeaturePackPackage pkg : featurePack.getPackages()) {
                ElementNode pkgElement = ProvisionedStateXmlWriter.addElement(packages, ProvisionedStateXmlParser10.Element.PACKAGE);
                ProvisionedStateXmlWriter.addAttribute(pkgElement, ProvisionedStateXmlParser10.Attribute.NAME, pkg.getName());
            }
        }
    }
}

