/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.map;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.aesh.command.Command;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.map.MapCommand;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.readline.AeshContext;

public class MapCommandPopulator
implements CommandPopulator<Object, Command> {
    private final MapCommand<?> instance;
    private final Map<String, String> unknownOptions = new HashMap<String, String>();

    MapCommandPopulator(MapCommand<?> instance) {
        Objects.requireNonNull(instance);
        this.instance = instance;
    }

    @Override
    public void populateObject(ProcessedCommand<Command> processedCommand, InvocationProviders invocationProviders, AeshContext aeshContext, CommandLineParser.Mode validate) throws CommandLineParserException, OptionValidatorException {
        String val;
        if (processedCommand.parserExceptions().size() > 0) {
            throw processedCommand.parserExceptions().get(0);
        }
        for (String name : this.unknownOptions.keySet()) {
            this.instance.setValue(name, this.unknownOptions.get(name));
        }
        this.unknownOptions.clear();
        if (processedCommand.getArguments() != null) {
            if (processedCommand.getArguments().getValues().size() > 0) {
                val = processedCommand.getArguments().getValue();
                if (val != null) {
                    this.instance.setValue(processedCommand.getArguments().name(), processedCommand.getArguments().doConvert(val, invocationProviders, this.instance, aeshContext, validate == CommandLineParser.Mode.VALIDATE));
                } else if (processedCommand.getArguments().getDefaultValues().size() > 0) {
                    this.instance.setValue(processedCommand.getArgument().name(), processedCommand.getArgument().getDefaultValues().get(0));
                } else {
                    this.instance.resetValue(processedCommand.getArguments().name());
                }
            } else {
                this.instance.resetValue(processedCommand.getArguments().name());
            }
        }
        if (processedCommand.getArgument() != null) {
            if (processedCommand.getArgument().getValues().size() > 0) {
                val = processedCommand.getArgument().getValue();
                if (val != null) {
                    this.instance.setValue(processedCommand.getArgument().name(), processedCommand.getArgument().doConvert(val, invocationProviders, this.instance, aeshContext, validate == CommandLineParser.Mode.VALIDATE));
                } else if (processedCommand.getArgument().getDefaultValues().size() > 0) {
                    this.instance.setValue(processedCommand.getArgument().name(), processedCommand.getArgument().getDefaultValues().get(0));
                } else {
                    this.instance.resetValue(processedCommand.getArgument().name());
                }
            } else {
                this.instance.resetValue(processedCommand.getArgument().name());
            }
        }
        for (ProcessedOption option : processedCommand.getOptions()) {
            if (option.getValue() != null) {
                this.instance.setValue(option.name(), option.doConvert(option.getValue(), invocationProviders, this.instance, aeshContext, validate == CommandLineParser.Mode.VALIDATE));
                continue;
            }
            if (option.getDefaultValues().size() > 0) {
                this.instance.setValue(option.name(), option.getDefaultValues().get(0));
                continue;
            }
            this.instance.resetValue(option.name());
        }
    }

    @Override
    public Object getObject() {
        return this.instance;
    }

    public void addUnknownOption(String opt) {
        if (opt.startsWith("--")) {
            opt = opt.substring(2);
        } else if (opt.startsWith("-")) {
            opt = opt.substring(1);
        }
        int i = opt.indexOf("=");
        String name = opt;
        String value = null;
        if (i > 0) {
            name = opt.substring(0, i);
            value = opt.substring(i + 1);
        }
        this.unknownOptions.put(name, value);
    }
}

