/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.filesystem;

import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.filesystem.FileAndNodeCompleter;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;

@CommandDefinition(name="cd", description="Changes the current work dir or FP node to the specified location")
public class CdCommand
extends PmSessionCommand {
    @Argument(completer=FileAndNodeCompleter.class)
    private String path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.path == null || this.path.isEmpty()) {
            return;
        }
        String currentPath = session.getPmSession().getCurrentPath();
        if (currentPath == null) {
            this.cdDir(session);
        } else {
            try {
                this.cdFp(session);
            }
            catch (PathConsumerException | PathParserException ex) {
                throw new CommandExecutionException(ex.getLocalizedMessage(), ex);
            }
        }
    }

    private void cdDir(PmCommandInvocation session) {
        FileResource res = new FileResource(this.path);
        AeshContext aeshCtx = session.getAeshContext();
        List<Resource> files = res.resolve(aeshCtx.getCurrentWorkingDirectory());
        if (files.get(0).isDirectory()) {
            aeshCtx.setCurrentWorkingDirectory(files.get(0));
        }
        session.setPrompt(PmSession.buildPrompt(aeshCtx));
    }

    private void cdFp(PmCommandInvocation session) throws CommandExecutionException, PathParserException, PathConsumerException {
        PmSession pm = session.getPmSession();
        String currentPath = pm.getCurrentPath();
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(pm.getContainer(), true);
        if (this.path.startsWith("/")) {
            pm.setCurrentPath(null);
        } else if (this.path.equals("..")) {
            if (currentPath == null) {
                throw new CommandExecutionException("No path entered");
            }
            if (currentPath.equals("/")) {
                return;
            }
            int i = (currentPath = currentPath.substring(0, currentPath.length() - 1)).lastIndexOf("/");
            this.path = i < 0 ? "/" : currentPath.substring(0, i);
            if (this.path.isEmpty()) {
                this.path = "/";
            }
            pm.setCurrentPath(null);
        } else {
            this.path = currentPath + this.path;
        }
        PathParser.parse(this.path, consumer);
        Group grp = consumer.getCurrentNode(this.path);
        if (grp == null) {
            return;
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + '/';
        }
        pm.setCurrentPath(this.path);
        String prompt = "/".equals(grp.getIdentity().getName()) ? (pm.getContainer().getName() == null ? "" : pm.getContainer().getName()) + '/' : grp.getIdentity().getName() + '/';
        session.setPrompt(PmSession.buildPrompt(prompt));
    }
}

