/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.cli.AbstractFeaturePackCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.state.StateInfoTypeCompleter;
import org.jboss.galleon.cli.model.ConfigInfo;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeaturePackInfo;

@CommandDefinition(name="info", description="Display information for a feature-pack or installation directory or editing state")
public class StateInfoCommand
extends AbstractFeaturePackCommand {
    @Option(completer=StateInfoTypeCompleter.class)
    private String type;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            FeatureContainer container = this.getFeatureContainer(invoc.getPmSession(), invoc.getAeshContext());
            if (this.type == null) {
                this.displayDependencies(invoc, container);
                this.displayConfigs(invoc, container);
            } else {
                switch (this.type) {
                    case "configs": {
                        this.displayConfigs(invoc, container);
                        break;
                    }
                    case "dependencies": {
                        this.displayDependencies(invoc, container);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(ex);
        }
    }

    private void displayConfigs(PmCommandInvocation invoc, FeatureContainer container) {
        invoc.println("configurations");
        if (container.getFinalConfigs().isEmpty()) {
            invoc.println("  NONE");
        } else {
            for (Map.Entry<String, List<ConfigInfo>> entry : container.getFinalConfigs().entrySet()) {
                invoc.println("  " + entry.getKey());
                for (ConfigInfo info : entry.getValue()) {
                    invoc.println("    " + info.getName());
                }
            }
        }
    }

    private void displayDependencies(PmCommandInvocation invoc, FeatureContainer container) {
        if (container instanceof FeaturePackInfo) {
            invoc.println("feature-pack " + container.getGav());
        }
        invoc.println("dependencies");
        if (container.getDependencies().isEmpty()) {
            invoc.println("  NONE");
        } else {
            for (ArtifactCoords.Gav dep : container.getDependencies()) {
                invoc.println("  " + dep.toString());
            }
        }
    }
}

